#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

my $PAGE_ID = 12345;

run_tests(
    sub {
        my ($app) = @_;

        $app->page_options->update($PAGE_ID, enable => ['ssp', 'mobile-app'], disable => ['no-turl']);

        cmp_deeply(
            $app->page_options->get_options($PAGE_ID, disable => ['internal']),
            {Enable => ['mobile-app', 'ssp'], Disable => ['internal', 'no-turl']},
            'page_options->get_options'
        );
    },
);
