#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

my $PAGE_ID = 12345;

run_tests(
    sub {
        my ($app) = @_;

        my %opts = (enable => ['mobile-app', 'ssp'], disable => ['no-turl']);

        $app->page_options->update($PAGE_ID, %opts);

        cmp_deeply(
            $app->page_options->get($PAGE_ID, fields => [qw(options)]),
            {options => \%opts},
            'page_options->update'
        );
    },
);
