#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'once';
        my $tables = $Application::Model::PartnerDB::AllPages::TABLES;

        foreach my $t_data (@$tables) {
            my ($model, $multistate) = @{$t_data}{qw( table  multistate )};

            subtest $model => sub {
                foreach my $multistate_name (keys %$multistate) {
                    my $got    = $app->$model->get_multistate_by_name($multistate_name);
                    my $expect = $multistate->{$multistate_name};

                    is($got, $expect, $model . '  - ' . $multistate_name);
                }
              }
        }
    },
    dont_create_database => 1,
);
