#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Mock qw(restore_subs);
use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        restore_subs([qw(Application::Model::PartnerDB::all_pages)]);

        my $meta = $app->partner_db->get_all_meta();

        foreach my $table (sort keys(%{$meta->{'tables'}})) {
            next unless $app->partner_db->$table()->is_view();

            my $sql = $app->partner_db->$table->create_sql();

            my $expected = get_test_data_and_update_if_needed($table, $sql, raw => TRUE);

            eq_or_diff($sql, $expected, $table, {context => 5});
        }
    },
    dont_create_database => 1,
);
