#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::More;

use qbit;

my $TIMEOUT          = 2;
my $TRIES            = 2;
my $CNT_INFO_CALLED  = 0;
my $CNT_ERROR_CALLED = 0;
my @got_log;

run_tests(
    sub {
        my ($app) = @_;

        {
            $QBit::Application::Model::DB::DBH_KEY = \'100500';
            QBit::Application::Model::DB::mysql::_connect($app->partner_db);
            $app->partner_db->_do(sprintf('lock tables all_pages a write, all_pages b read;'));
            $QBit::Application::Model::DB::DBH_KEY = \undef;
        }

        my $orig_sub_info  = \&Application::Model::PartnerDB::INFO;
        my $orig_sub_error = \&Application::Model::PartnerDB::ERROR;
        mock_subs(
            {
                'Application::Model::PartnerDB::INFO' => sub {
                    $CNT_INFO_CALLED++;
                    push @got_log, [_normalize_log_message($_[0])];
                    return $orig_sub_info->(@_);
                },
                'Application::Model::PartnerDB::ERROR' => sub {
                    $CNT_ERROR_CALLED++;
                    push @got_log, [_normalize_log_message($_[0]->{message})];
                    return $orig_sub_error->(@_);
                },
            }
        );

        $app->partner_db->update_table(
            'all_pages',
            sub {
                my ($new_table) = @_;

                my $db = $new_table->db;

                my @fields = sort $db->all_pages_view->field_names();

                $new_table->add_multi(
                    [
                        $db->query->select(
                            table  => $db->all_pages_view,
                            fields => \@fields,
                        )
                    ],
                    fields => \@fields
                );
            },
            {
                timeout => $TIMEOUT,
                tries   => $TRIES,
            }
        );
        my $expected = get_test_data_and_update_if_needed('log.json', \@got_log);
        is_deeply(\@got_log, $expected, 'check log');

        {
            $QBit::Application::Model::DB::DBH_KEY = \'100500';
            QBit::Application::Model::DB::mysql::_connect($app->partner_db);
            $app->partner_db->_do(sprintf('unlock tables;'));
        }
    },
    do_not_die_on_fail => 1
);

sub _normalize_log_message {
    my $error_message = shift;
    $error_message =~ s/elapsed: [\d.]+/elapsed: ELAPSED/;
    $error_message =~ s/all_pages_new_\d+_\d+/all_pages_new_0_0/g;
    return $error_message;
}
