#!/usr/bin/perl -w

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;
use Test::More;
use Test::Differences qw(eq_or_diff);
use PiConstants qw($IS_PRECISE);

my @mol_answer = (
    {
        'data'       => [['2021-07-05', '2021-07-01', '348519865', '373283446', '-6.63398853213544', -24763581]],
        'duration'   => '0.251',
        'error_text' => '',
        'header'     => [
            'UpdateTime_a',            'UpdateTime_b',
            'MixedPartnerPrice_a',     'MixedPartnerPrice_b',
            'MixedPartnerPrice_delta', 'MixedPartnerPrice_absdelta'
        ],
        'host-aggregator' => 'localhost',
        'stat_time'       => 0,
        'status'          => 0,
        'total_rows'      => 1,
        'totals'          => {
            'MixedPartnerPrice_a'        => '348519865',
            'MixedPartnerPrice_absdelta' => -24763581,
            'MixedPartnerPrice_b'        => '373283446',
            'MixedPartnerPrice_delta'    => '-6.63398853213544',
        }
    },
    {
        'data' => [
            [
                '2021-07-05',        '2021-07-01',        '8094',             '7405',
                '9.30452397029034',  689,                 '6833',             '5991',
                '14.054414955767',   842,                 '4919',             '4355',
                '12.9506314580941',  564,                 '43059039.4119101', '50409648.3457124',
                '-14.5817500717152', '-7350608.9338023',  '70851771.7015654', '85713764.8679679',
                '-17.3390973891949', '-14861993.1664025', '51005395.1412264', '62307368.7197463',
                '-18.1390641440105', '-11301973.5785199', '348519865',        '373283446',
                '-6.63398853213544', -24763581
            ]
        ],
        'duration'   => '0.606',
        'error_text' => '',
        'header'     => [
            'UpdateTime_a',            'UpdateTime_b',
            'Hits_a',                  'Hits_b',
            'Hits_delta',              'Hits_absdelta',
            'RenderHits_a',            'RenderHits_b',
            'RenderHits_delta',        'RenderHits_absdelta',
            'RenderShows_a',           'RenderShows_b',
            'RenderShows_delta',       'RenderShows_absdelta',
            'RPMPartner_a',            'RPMPartner_b',
            'RPMPartner_delta',        'RPMPartner_absdelta',
            'CPMVPartner_a',           'CPMVPartner_b',
            'CPMVPartner_delta',       'CPMVPartner_absdelta',
            'ECPMPartner_a',           'ECPMPartner_b',
            'ECPMPartner_delta',       'ECPMPartner_absdelta',
            'MixedPartnerPrice_a',     'MixedPartnerPrice_b',
            'MixedPartnerPrice_delta', 'MixedPartnerPrice_absdelta'
        ],
        'host-aggregator' => 'localhost',
        'stat_time'       => 0,
        'status'          => 0,
        'total_rows'      => 1,
        'totals'          => {
            'CPMVPartner_a'              => '70851771.7015654',
            'CPMVPartner_absdelta'       => '-14861993.1664025',
            'CPMVPartner_b'              => '85713764.8679679',
            'CPMVPartner_delta'          => '-17.3390973891949',
            'ECPMPartner_a'              => '51005395.1412264',
            'ECPMPartner_absdelta'       => '-11301973.5785199',
            'ECPMPartner_b'              => '62307368.7197463',
            'ECPMPartner_delta'          => '-18.1390641440105',
            'Hits_a'                     => '8094',
            'Hits_absdelta'              => 689,
            'Hits_b'                     => '7405',
            'Hits_delta'                 => '9.30452397029034',
            'MixedPartnerPrice_a'        => '348519865',
            'MixedPartnerPrice_absdelta' => -24763581,
            'MixedPartnerPrice_b'        => '373283446',
            'MixedPartnerPrice_delta'    => '-6.63398853213544',
            'RPMPartner_a'               => '43059039.4119101',
            'RPMPartner_absdelta'        => '-7350608.9338023',
            'RPMPartner_b'               => '50409648.3457124',
            'RPMPartner_delta'           => '-14.5817500717152',
            'RenderHits_a'               => '6833',
            'RenderHits_absdelta'        => 842,
            'RenderHits_b'               => '5991',
            'RenderHits_delta'           => '14.054414955767',
            'RenderShows_a'              => '4919',
            'RenderShows_absdelta'       => 564,
            'RenderShows_b'              => '4355',
            'RenderShows_delta'          => '12.9506314580941'
        }
    },
    {
        'data'       => [],
        'duration'   => '0.193',
        'error_text' => '',
        'header'     => [
            'UpdateTime_a',            'UpdateTime_b',
            'Hits_a',                  'Hits_b',
            'Hits_delta',              'Hits_absdelta',
            'RenderHits_a',            'RenderHits_b',
            'RenderHits_delta',        'RenderHits_absdelta',
            'RenderShows_a',           'RenderShows_b',
            'RenderShows_delta',       'RenderShows_absdelta',
            'RPMPartner_a',            'RPMPartner_b',
            'RPMPartner_delta',        'RPMPartner_absdelta',
            'CPMVPartner_a',           'CPMVPartner_b',
            'CPMVPartner_delta',       'CPMVPartner_absdelta',
            'ECPMPartner_a',           'ECPMPartner_b',
            'ECPMPartner_delta',       'ECPMPartner_absdelta',
            'MixedPartnerPrice_a',     'MixedPartnerPrice_b',
            'MixedPartnerPrice_delta', 'MixedPartnerPrice_absdelta'
        ],
        'host-aggregator' => 'localhost',
        'stat_time'       => 0,
        'status'          => 0,
        'total_rows'      => 0,
        'totals'          => {
            'CPMVPartner_a'              => 0,
            'CPMVPartner_absdelta'       => 0,
            'CPMVPartner_b'              => 0,
            'CPMVPartner_delta'          => 0,
            'ECPMPartner_a'              => 0,
            'ECPMPartner_absdelta'       => 0,
            'ECPMPartner_b'              => 0,
            'ECPMPartner_delta'          => 0,
            'Hits_a'                     => 0,
            'Hits_absdelta'              => 0,
            'Hits_b'                     => 0,
            'Hits_delta'                 => 0,
            'MixedPartnerPrice_a'        => 0,
            'MixedPartnerPrice_absdelta' => 0,
            'MixedPartnerPrice_b'        => 0,
            'MixedPartnerPrice_delta'    => 0,
            'RPMPartner_a'               => 0,
            'RPMPartner_absdelta'        => 0,
            'RPMPartner_b'               => 0,
            'RPMPartner_delta'           => 0,
            'RenderHits_a'               => 0,
            'RenderHits_absdelta'        => 0,
            'RenderHits_b'               => 0,
            'RenderHits_delta'           => 0,
            'RenderShows_a'              => 0,
            'RenderShows_absdelta'       => 0,
            'RenderShows_b'              => 0,
            'RenderShows_delta'          => 0
        }
    }
);

sub mock_mol_array {
    my ($app, $data) = @_;

    $app->api_http_mol;
    $app->{'api_http_mol'} = Test::MockObject::Extends->new($app->{'api_http_mol'});

    $app->api_http_mol->mock(
        'get_data',
        sub {
            my $r;
            if (@$data == 1) {
                $r = $data->[0];
            } else {
                $r = shift @$data;
            }
            return clone($r);
        }
    );
}

run_tests(\&main_test, init => [qw(partner_monitoring)],);

sub main_test {
    my ($app) = @_;

    mock_mol_array($app, \@mol_answer);

    my $data = $app->partner_monitoring->get_data_for_monitoring_mol(
        date         => '2021-07-05',
        compare_date => '2021-07-01'
    );

    # из-за разного часового пояса таймстампы отличаются
    for my $row (@$data) {
        $row->{product} =~ s/\d{10,20}/TIMESTAMP/g;
    }

    my $expected = get_test_data_and_update_if_needed("data.json", $data);

    eq_or_diff($data, $expected, 'check results', {context => 10});

    mock_subs({'Application::Model::Resources::get_get_resources' => sub {{}},});
    my $got = $app->partner_monitoring->get_data_for_monitoring_mol(
        date         => '2021-07-05',
        compare_date => '2021-07-01'
    );
    is_deeply($got, [], 'partner without offer accepted = no stat');
}
