#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_bk_data);

use DDP;
use Test::More;
use Test::Deep;
use Test::Exception;

use qbit;
use PiConstants qw(@YAN_MIRRORS_LIST);

run_tests(
    sub {
        my ($app) = @_;
        my $campaign_id = 41443;

        ####### Мanager can edit mirrors without moderation
        {
            change_cur_user($app, 'mocked-yan-manager');

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror.ru'      => 'new',
                    'approvedmirror.ru' => 'approved',
                },
                ' – initial mirrors ok'
            );

            cmp_bag(
                get_bk_data($app->context_on_site_campaign, {id => $campaign_id})->{mirrors},
                [('approvedmirror.ru'), @YAN_MIRRORS_LIST],
                ' – initial bk_data ok'
            );

            throws_ok {
                $app->context_on_site_campaign->mirrors->check($campaign_id, 'approvedmirror.ru');
            }
            qr/Mirror "approvedmirror.ru" already exists/, ' - it is not possible to add existing mirror';

            $app->context_on_site_campaign->do_action($campaign_id, 'edit',
                mirrors => ['newmirror.ru', 'approvedmirror.ru', 'rejectedmirror.ru', 'deletedmirror.ru']);

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror.ru'      => 'new',
                    'approvedmirror.ru' => 'approved',
                    'rejectedmirror.ru' => 'approved',
                    'deletedmirror.ru'  => 'approved',
                },
                ' – added mirrors ok'
            );

            cmp_bag(
                get_bk_data($app->context_on_site_campaign, {id => $campaign_id})->{mirrors},
                [('approvedmirror.ru', 'rejectedmirror.ru', 'deletedmirror.ru'), @YAN_MIRRORS_LIST],
                ' – added mirrors in bk_data ok'
            );

            ok(
                $app->context_on_site_campaign->check_multistate_flag(
                    $app->context_on_site_campaign->get($campaign_id, fields => ['multistate'])->{multistate},
                    'need_update'
                ),
                ' – page multistate is need_update ok'
              );

            $app->context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => ['newmirror.ru']);

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {'newmirror.ru' => 'new',},
                ' – deleted mirrors ok'
            );

            cmp_bag(get_bk_data($app->context_on_site_campaign, {id => $campaign_id})->{mirrors},
                [@YAN_MIRRORS_LIST], ' – deleted mirrors in bk_data ok');
        }
    },
);
