#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_bk_data);
use Test::Differences qw( eq_or_diff );

use DDP;
use Test::More;
use Test::Deep;
use Test::Exception;

use qbit;
use PiConstants qw(@YAN_MIRRORS_LIST);

run_tests(
    sub {
        my ($app) = @_;
        my ($campaign_id, $page_id) = (41443, 41443);

        ####### Partner can edit mirrors with moderation only
        {
            change_cur_user($app, 'mocked-yan-partner');

            my $mirrors = [qw(approvedmirror.ru newmirror.ru rejectedmirror.ru deletedmirror.ru)];
            $app->context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => $mirrors);

            eq_or_diff(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror.ru'      => 'new',
                    'approvedmirror.ru' => 'approved',
                    'rejectedmirror.ru' => 'new',
                    'deletedmirror.ru'  => 'new',
                },
                ' – added mirrors ok'
            );

            cmp_bag(
                get_bk_data($app->context_on_site_campaign, {id => $campaign_id})->{mirrors},
                [('approvedmirror.ru'), @YAN_MIRRORS_LIST],
                ' – added mirrors are not presented in bk_data'
            );

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->moderation->get_all(fields => ['mirrors'], filter => {page_id => $page_id})->[0]{mirrors}}
                },
                {map {$_ => 'new'} qw(rejectedmirror.ru deletedmirror.ru)},
                ' – moderation request for mirrors ok'
            );

            ok(
                $app->context_on_site_campaign->check_multistate_flag(
                    $app->context_on_site_campaign->get($campaign_id, fields => ['multistate'])->{multistate},
                    'need_update'
                ),
                ' – page multistate is need_update ok'
              );

            $mirrors = [grep {$_ ne 'approvedmirror.ru'} @$mirrors];
            $app->context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => $mirrors);

            cmp_deeply(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {map {$_ => 'new'} @$mirrors,},
                ' – deleted mirror ok'
            );

            cmp_bag(get_bk_data($app->context_on_site_campaign, {id => $campaign_id})->{mirrors},
                [@YAN_MIRRORS_LIST], ' – deleted mirrors are not in bk_data');
        }

        # PI-10220 – принимаем зеркала Дзена без модерации
        {
            my $mirrors = [qw(zen.yandex.ru/media/id/595d153a4ffd13b1f40e2589)];
            $app->context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => $mirrors);

            eq_or_diff(
                {
                    map {$_->{domain} => $_->{moderation_status}}
                      @{$app->context_on_site_campaign->get($campaign_id, fields => ['mirrors'])->{mirrors}}
                },
                {
                    'newmirror.ru'      => 'new',
                    'rejectedmirror.ru' => 'new',
                    'deletedmirror.ru'  => 'new',
                    'zen.yandex.ru'     => 'approved'
                },
                ' – added zen.yandex.ru ok'
            );

        }
    },
    mocks => ['mock_zora'],
);
