use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Differences;
use Test::Partner::Utils;

use Test::More;

# use POSIX;

my $REQUEST_COUNTER = 0;

run_tests(\&main_test, mock_moneymap => TRUE,);

sub main_test {
    my ($app) = @_;

    mock_mailer($app);
    mock_utils_partner2($app);

    my @result;
    $app->{'api_moneymap'}->mock(
        'add_page',
        sub {
            my ($self, %params) = @_;
            push @result, ["add_page", \%params];
        }
    );
    $app->{'api_moneymap'}->mock(
        'edit_page',
        sub {
            my ($self, %params) = @_;
            push @result, ["edit_page", \%params];
        }
    );

    my $id = $app->context_on_site_campaign->add(
        'domain_id' => 2,
        'login'     => 'mocked-yan-partner',
        caption     => 'Init caption',
        moneymap    => {
            "abc_id"           => 111,
            "abc_oebs_id"      => 222,
            "os"               => "",
            "page_type"        => "internal",
            "platform"         => "desktop",
            "sub_traffic_type" => "native",
            "traffic_type"     => "web"
        }
    );
    $app->context_on_site_campaign->do_action(
        $id, "edit",
        caption  => 'Edited caption',
        moneymap => {
            "abc_id"           => 333,
            "abc_oebs_id"      => 444,
            "os"               => "",
            "page_type"        => "internal",
            "platform"         => "desktop",
            "sub_traffic_type" => "native",
            "traffic_type"     => "web"
        }
    );

    my $has = get_test_data_and_update_if_needed('data.json', \@result);
    eq_or_diff(\@result, $has, 'compare data');

}
