use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;

use Test::More;

use POSIX;

my $REQUEST_COUNTER = 0;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_moneymap;
        $app->{'api_moneymap'} = Test::MockObject::Extends->new($app->{'api_moneymap'});
        $app->{'api_moneymap'}->mock(
            'pages',
            sub {
                $REQUEST_COUNTER++;
                return {"pages" => []};
            }
        );

        my $result = $app->context_on_site_campaign->get_all(fields => [qw(id moneymap)]);
        my $chunks_count = ceil((scalar @$result) / 1000);

        ok($REQUEST_COUNTER == $chunks_count, 'one request to MoneyMap performed for every 1000 items in get_all');
    }
);
