use Test::Partner2::Simple;

use Test::Most;
use Test::More;
use Test::MockObject::Extends;
use Test::Partner2::Mock;

use qbit;

my $ID = 1;

my $TEST_DATA = [
    {
        method     => 'cron_init_campaigns',
        args       => [],
        status     => 'testing',
        expected   => TRUE,
        tmp_rights => ['do_context_on_site_register_in_balance', 'do_context_on_site_start_testing'],
    },
    {
        method   => 'do_action',
        args     => [$ID, 'stop'],
        status   => 'stopped',
        expected => TRUE,
    },
    {
        method   => 'do_action',
        args     => [$ID, 'delete'],
        status   => 'deleted',
        expected => TRUE,
    },
    {
        method   => 'do_action',
        args     => [$ID, 'restore'],
        status   => 'need_update',
        expected => TRUE,
    },
    {
        method   => 'update_in_bk',
        args     => [{page_id => $ID}],
        status   => 'need_update',
        expected => FALSE,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->api_bk;
        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});
        my $PAGE_ID = 0;
        $app->api_bk->mock(
            'create_or_update_campaign',
            sub {
                my ($self, $campaign) = @_;

                my $return;
                if ($campaign->{page_id}) {
                    return $campaign->{page_id};
                } else {
                    $PAGE_ID++;
                    return $PAGE_ID;
                }
            }
        );

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
        $app->api_balance->mock('create_or_update_place', sub {1});

        $app->api_bk->mock(
            'create_or_update_campaigns',
            sub {
                return [{}];
            }
        );

        foreach my $test_case (@$TEST_DATA) {
            my $tmp_rights;
            if ($test_case->{tmp_rights}) {
                $tmp_rights = $app->add_tmp_rights(@{$test_case->{tmp_rights}});
            }

            my $method = $test_case->{method};
            my @args   = @{$test_case->{args}};
            $app->context_on_site_campaign->$method(@args);

            is(
                $app->context_on_site_campaign->check_multistate_flag(
                    $app->context_on_site_campaign->get($ID, fields => ['multistate'])->{'multistate'},
                    $test_case->{status}
                ),
                $test_case->{expected},
                'Check status ' . $test_case->{status},
              );
        }
    },
    user => 'mocked-yan-partner'
);
