#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(set_test_partner_utils_app set_bit_by_name get_bk_data get_new_an_rtb);

use Test::More;
use Test::Deep;

use qbit;
use PiConstants qw(@YAN_MIRRORS_LIST);

my $PARTNER_LOGIN = 'mocked-yan-partner';
my $MANAGER_LOGIN = 'mocked-yan-manager';
my $CAMP_ID       = 41443;
my $PAGE_ID       = 41443;
my $BLOCK_ID      = 1;

run_tests(
    sub {
        my ($app) = @_;

        mock_format_system($app);
        mock_yt_picategory_mapping($app);

        set_test_partner_utils_app($app);

        set_bit_by_name(
            'context_on_site_campaign',
            {id => $CAMP_ID},
'working and balance_registered and not (need_approve or rejected or deleted or protected or blocked or need_update or updating)'
        );

        my $bk_data = get_bk_data($app->context_on_site_campaign, {id => $CAMP_ID});

        cmp_deeply($bk_data->{'mirrors'}, [('approvedmirror.ru'), @YAN_MIRRORS_LIST], 'check mirrors');
        cmp_deeply(
            $bk_data->{'page_options'},
            {
                'Disable' => [sort ('adblock',               'performance-tgo-disable', 'unmoderated-rtb-auction')],
                'Enable'  => [sort ('check-target-ref-only', 'redir-to-page-handler')]
            },
            'check page_options'
        );

        my $campaign = $app->context_on_site_campaign->get($CAMP_ID, fields => [qw(available_fields editable_fields)]);

        foreach (qw(allowed_amp allowed_turbo)) {
            ok($campaign->{'available_fields'}{$_}, "$_ exists into available_fields");
            ok(!$campaign->{'editable_fields'}{$_}, "$_ not exists into editable_fields");
        }

        check_block_options(
            $app,
            {
                'Enable'  => [],
                'Disable' => [
                    sort('rtbshadow', 'filter-sizes', 'ignore-0x0-adaptive-sizes', 'amp',
                        'turbo', 'turbo-desktop', 'rewarded', 'fullscreen')
                ]
            },
            'check PageImpOptions for desktop',
            filter => {campaign_id => $PAGE_ID, id => $BLOCK_ID}
        );

        check_block_options(
            $app,
            {
                'Enable'  => ['turbo'],
                'Disable' => [
                    sort('rtbshadow', 'filter-sizes', 'ignore-0x0-adaptive-sizes', 'amp',
                        'turbo-desktop', 'rewarded', 'fullscreen')
                ]
            },
            'check PageImpOptions for turbo',
            site_version => 'turbo',
        );

        check_block_options(
            $app,
            {
                'Enable'  => ['amp'],
                'Disable' => [
                    sort('rtbshadow', 'filter-sizes', 'ignore-0x0-adaptive-sizes', 'turbo',
                        'turbo-desktop', 'rewarded', 'fullscreen')
                ]
            },
            'check PageImpOptions for amp',
            site_version => 'amp',
        );

        change_cur_user($app, $MANAGER_LOGIN);

        $campaign = $app->context_on_site_campaign->get($CAMP_ID, fields => [qw(available_fields editable_fields)]);

        foreach (qw(allowed_amp allowed_turbo)) {
            ok($campaign->{'available_fields'}{$_}, "$_ exists into available_fields");
            ok($campaign->{'editable_fields'}{$_},  "$_ exists into editable_fields");
        }

        $app->context_on_site_campaign->do_action($CAMP_ID, 'edit', allowed_amp => 0, allowed_turbo => 0);

        $bk_data = get_bk_data($app->context_on_site_campaign, {id => $CAMP_ID});

        cmp_deeply($bk_data->{'mirrors'}, ['approvedmirror.ru'], 'check mirrors');
        cmp_deeply(
            $bk_data->{'page_options'},
            {
                'Disable' =>
                  [sort ('adblock', 'check-target-ref-only', 'performance-tgo-disable', 'unmoderated-rtb-auction')],
                'Enable' => ['redir-to-page-handler']
            },
            'check page_options'
        );

        $campaign =
          $app->context_on_site_campaign->get($CAMP_ID,
            fields => [qw(allowed_amp allowed_turbo available_fields editable_fields)]);

        ok(!$campaign->{'allowed_amp'},   "allowed_amp : false");
        ok(!$campaign->{'allowed_turbo'}, "allowed_turbo : false");

        foreach (qw(allowed_amp allowed_turbo)) {
            ok($campaign->{'available_fields'}{$_}, "$_ exists into available_fields");
            ok($campaign->{'editable_fields'}{$_},  "$_ exists into editable_fields");
        }

        change_cur_user($app, $PARTNER_LOGIN);

        $campaign = $app->context_on_site_campaign->get($CAMP_ID, fields => [qw(available_fields editable_fields)]);

        foreach (qw(allowed_amp allowed_turbo)) {
            ok(!$campaign->{'available_fields'}{$_}, "$_ exists into available_fields");
            ok(!$campaign->{'editable_fields'}{$_},  "$_ not exists into editable_fields");
        }
    },
    user => $PARTNER_LOGIN
);

sub check_block_options {
    my ($app, $result, $msg, %opts) = @_;

    my ($filter, $block_id);
    if ($opts{'site_version'}) {
        my $rtb_settings = get_new_an_rtb(
            {
                campaign_id   => $PAGE_ID,
                site_version  => $opts{'site_version'},
                delete_fields => [qw(show_video)],
            }
        );

        my $public_id = $app->context_on_site_rtb->add(%{$rtb_settings});
        $block_id = $app->context_on_site_rtb->_split_id($public_id)->{'id'};

        $filter = {campaign_id => $PAGE_ID, id => $block_id};
    } else {
        $filter   = $opts{'filter'};
        $block_id = $filter->{'id'};
    }

    my $blocks_bk_data = get_bk_data($app->context_on_site_rtb, $filter);

    cmp_deeply($blocks_bk_data->{$block_id}{'PageImpOptions'}, $result, $msg);
}
