#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Exception;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $public_id = $app->context_on_site_content->add(
            "adfox_block"   => 1,
            "adv_positions" => [2],
            "caption"       => "Блок",
            "css"           => "__fake_css__",
            "grid_columns"  => 4,
            "grid_rows"     => 1,
            "mincpm"        => undef,
            "need_pictures" => 1,
            "news_params"   => {
                "candidates" => [
                    {
                        "host"                   => "showmethemoney.ru",
                        "tags"                   => [],
                        "tags_blacklist"         => [],
                        "url_prefixes"           => [],
                        "url_prefixes_blacklist" => []
                    }
                ],
                "filter_clicked" => 0,
                "model_type"     => "ctr"
            },
            "page_id"  => 41443,
            "strategy" => "1",
            "template" => "__fake_template__"
        );

        cmp_deeply(
            $app->context_on_site_content->get(
                $public_id,
                fields => [
                    qw(
                      public_id
                      adfox_block
                      )
                ]
            ),
            {
                'adfox_block' => '1',
                'public_id'   => $public_id,
            },
            'get adfox fields'
        );

        throws_ok {
            $app->context_on_site_content->do_action($public_id, 'delete');
        }
        "Exception::Multistate::BadAction", "Can't delete adfox_block";

        $app->context_on_site_content->do_action($public_id, 'delete_from_adfox');

    },
    user => 'mocked-yan-partner'
);
