use Test::More tests => 3;
use Test::Deep;

use qbit;

use Test::Partner2::Simple;

my $test_page_id = 41443;

run_tests(
    sub {
        my ($app) = @_;

        my $bk_data = $app->context_on_site_content->get_bk_data($test_page_id);

        my $path_to_data = lib::abs::path('bk_data/data.json');
        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            writefile($path_to_data, to_json($bk_data, pretty => TRUE));
        }

        my $json_data = from_json(readfile($path_to_data));

        cmp_deeply($bk_data, $json_data);
    },
);
