use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use qbit;

use Test::More;
use Test::Deep qw(cmp_deeply ignore);
use Test::Partner::Utils qw(get_new_an_rtb);

our @TEST_DATA = (
    {
        test_description => "Can't create RTB block with non boolean horizontal_align = 2",
        horizontal_align => 2,
        error_case       => 1,
    },
    {
        test_description => "Create RTB block with horizontal_align = 1",
        horizontal_align => 1,
    },
    {
        test_description => "Create RTB block with horizontal_align = 0",
        horizontal_align => 0,
    },
);

sub add_context_on_site_rtb {
    my ($app, $test) = @_;
    my $test_description = delete($test->{test_description});
    my $error_case       = delete($test->{error_case});

    my %data = ((campaign_id => 801, blind => 1, dsps => ['2317563'],), %{$test});

    if ($error_case) {
        eval {my $ids = $app->context_on_site_rtb->add(%{get_new_an_rtb(\%data)});};
        ok($@, $test_description);
        return 1;
    }

    my $public_id = $app->context_on_site_rtb->add(%{get_new_an_rtb(\%data)});
    like($public_id, qr/R-A-801-\d+/, $test_description . ' – block is ok');

    my $db_data = $app->context_on_site_rtb->get($public_id, fields => [qw(horizontal_align)],);

    cmp_deeply(
        $db_data,
        {'horizontal_align' => $test->{horizontal_align}},
        $test_description . ' – horizontal_align is ok'
    );

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_agreement_checker($app);
        mock_bk($app);
        mock_balance($app);
        mock_format_system($app);
        mock_yt_picategory_mapping($app);

        map {add_context_on_site_rtb($app, $_)} @TEST_DATA;

        return 1;
    },
);
__END__
