#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_new_an_rtb mock_curdate get_bk_data use_perl_do_actions);
use Test::Partner2::Mock;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        @PiConstants::VIDEO_AWAPS_DSPS = (1, 2563117);
        mock_yt_picategory_mapping($app);
        mock_curdate('2017-08-29 17:56:16');
        mock_format_system($app);

        $app->partner_db->context_on_site_campaign->edit($app->partner_db->filter({page_id => 41443}),
            {allowed_turbo => 1});

        cmp_deeply(
            $app->context_on_site_rtb->get_site_versions({page_id => 41443, adfox_block => 1}),
            {
                'desktop'           => 'Desktop',
                'amp'               => 'AMP-pages',
                'turbo'             => 'Turbo-pages',
                'turbo_desktop'     => 'Turbo-pages desktop',
                'mobile'            => 'Mobile',
                'mobile_floorad'    => 'Mobile floor_add',
                'mobile_fullscreen' => 'Mobile fullscreen',
                'mobile_rewarded'   => 'Mobile rewarded',
            },
            'get_site_versions'
        );

        cmp_deeply(
            $app->context_on_site_rtb->get_add_fields({adfox_block => 1}),
            superhashof({'adfox_block' => 1,}),
            'get_add_fields'
        );

        my $public_id = $app->context_on_site_rtb->add(
            %{
                get_new_an_rtb(
                    {
                        campaign_id  => 41443,
                        site_version => 'turbo',
                        adfox_block  => 1,
                        show_video   => 0
                    }
                )
              }
        );

        cmp_deeply($app->context_on_site_campaign->get({id => 41443}, fields => [qw(blocks_count)]),
            {'blocks_count' => 1});

        my $id = $app->context_on_site_rtb->_split_id($public_id);

        cmp_deeply(
            $app->context_on_site_rtb->get(
                $public_id,
                fields => [
                    qw(
                      public_id
                      adfox_block
                      available_fields
                      editable_fields
                      )
                ]
            ),
            {
                'adfox_block'      => '1',
                'available_fields' => superhashof({'adfox_block' => 1,}),
                'editable_fields'  => superhashof({}),
                'public_id'        => $public_id,
            },
            'gat_all'
        );

        use_perl_do_actions($app, 'context_on_site_rtb');
        $app->context_on_site_rtb->do_action($public_id, 'delete_from_adfox');

        cmp_deeply($app->context_on_site_campaign->get({id => 41443}, fields => [qw(blocks_count)]),
            {'blocks_count' => 0});
    },
    user => 'mocked-yan-partner'
);
