use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_new_an_rtb);
use qbit;

use Test::More;
use Test::Deep qw(cmp_deeply ignore);

run_tests(
    sub {
        my ($app) = @_;

        mock_format_system($app);

        my $expected = {
            page_id   => 801,
            id        => 1,
            unique_id => 6719275009,
        };
        my $public_id = $app->context_on_site_rtb->add(%{get_new_an_rtb({campaign_id => 801})});
        my $got = $app->context_on_site_rtb->get($public_id, fields => [qw(page_id id unique_id)],);
        is_deeply($got, $expected, 'adding unique_id ok');

        $got = $app->context_on_site_rtb->get_all(
            filter => {unique_id => 6719275009},
            fields => [qw(page_id id unique_id)],
        );
        is_deeply($got, [$expected], 'filter by unique_id ok');
    },
);
__END__
