#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw( compare_formats );

use Test::More;
use Test::Deep qw( cmp_deeply );
use Test::Differences qw( eq_or_diff );

use qbit;

my $page_id = 41443;

my $fixture = {
    "get_types_dsp_blocks" => [
        {"site_version" => "turbo"},
        {"site_version" => "mobile"},
        {"site_version" => "desktop"},
        {"site_version" => "turbo_desktop"},
        {"site_version" => "amp"},
    ]
};

run_tests(
    sub {
        my ($app) = @_;

        my $path_to_data = lib::abs::path('direct_blocks/data.json');
        my $json_data    = from_json(readfile($path_to_data));

        my $got_data = {};
        foreach my $method (keys %$fixture) {

            subtest $method => sub {
                note 'Start  ' . $method;

                my $got_buffer = [];
                for (my $i = 0; $i <= $#{$fixture->{$method}}; $i++) {

                    my ($site_version) = @{$fixture->{$method}->[$i]}{qw(site_version)};

                    my $expect = $json_data->{$method}->[$i]->{direct_blocks};

                    my $test_name = sprintf '%s (%s)', $method, $site_version;

                    subtest $test_name => sub {
                        note '  start  ' . $test_name;

                        my $data = $app->context_on_site_rtb->$method(
                            {
                                site_version => $site_version,
                                page_id      => $page_id
                            }
                        );

                        my $new_got = compare_formats($data, $expect, $test_name);

                        push @{$got_data->{$method}},
                          {
                            "site_version"  => $site_version,
                            "direct_blocks" => $new_got,
                          };
                      }
                }
              }
        }

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            writefile($path_to_data, to_json($got_data, pretty => TRUE));
        }

    },
    do_not_die_on_fail => TRUE,
);
