use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use qbit;

use Test::More;
use Test::Deep qw(cmp_deeply ignore);
use Test::Partner::Utils qw(get_new_an_rtb);

my $PUBLIC_ID = 'R-A-142898-3';

our @TEST_DATA = (
    {
        test_description => "Edit RTB block with horizontal_align = '1'",
        horizontal_align => '1',
    },
    {
        test_description => "Edit RTB block with horizontal_align = '0'",
        horizontal_align => '0',
    },
);

sub add_context_on_site_rtb {
    my ($app, $test) = @_;

    my %data = ((campaign_id => 142898, blind => 1, dsps => ['2317563']), %{$test});

    my $public_id = $app->context_on_site_rtb->add(%{get_new_an_rtb(\%data)});
    is($public_id, $PUBLIC_ID, 'Create block is ok');

    return 1;
}

sub do_action_context_on_site_rtb {
    my ($app, $test) = @_;
    my $test_description = delete($test->{test_description});
    my $horizontal_align = $test->{horizontal_align};

    my $before =
      $app->context_on_site_rtb->get($PUBLIC_ID, fields => [qw(available_fields editable_fields horizontal_align)],);

    ok($before->{available_fields}{horizontal_align},
        $test_description . ' – horizontal_align is in available_fields');
    ok($before->{editable_fields}{horizontal_align}, $test_description . ' – horizontal_align is in editable_fields');

    $app->context_on_site_rtb->do_action($PUBLIC_ID, 'edit', %{$test});

    my $after =
      $app->context_on_site_rtb->get($PUBLIC_ID, fields => [qw(available_fields editable_fields horizontal_align)],);

    is($after->{horizontal_align},
        $horizontal_align, $test_description . ' – finally horizontal_align = ' . $horizontal_align);

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_agreement_checker($app);
        mock_bk($app);
        mock_balance($app);
        mock_format_system($app);
        mock_yt_picategory_mapping($app);

        add_context_on_site_rtb($app, {});

        map {do_action_context_on_site_rtb($app, $_)} @TEST_DATA;

        return 1;
    },
    application_package => 'Rosetta'
);
__END__
