#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use PiConstants qw( $TECHNICAL_RTB_BLOCK_ID );    # Технический RTB блок (#PI-7517)

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $not_allowed_for_technical_rtb_block_available_fields = {
            map {$_ => 1}
              qw(
              alternative_code
              geo
              articles
              brands
              )
        };

        ####### Partner
        {
            change_cur_user($app, 'mocked-context-adblock-partner');

            my $block_fields = $app->context_on_site_rtb->get({campaign_id => 41443, id => $TECHNICAL_RTB_BLOCK_ID},
                fields => [qw(available_fields)]);
            my $available_fields = $block_fields->{'available_fields'};
            cmp_deeply(
                [grep {$not_allowed_for_technical_rtb_block_available_fields->{$_}} sort keys %$available_fields],
                [], 'Some fields is not allowed for a techical RTB block for regular partner - #PI-7517');
        }

        ####### Мanager
        {
            change_cur_user($app, 'mocked-yan-manager');

            my $block_fields = $app->context_on_site_rtb->get({campaign_id => 41443, id => $TECHNICAL_RTB_BLOCK_ID},
                fields => [qw(available_fields)]);
            my $available_fields = $block_fields->{'available_fields'};
            cmp_deeply(
                [grep {$not_allowed_for_technical_rtb_block_available_fields->{$_}} sort keys %$available_fields],
                [], 'Some fields is not allowed for a techical RTB block for a manager - #PI-7517');
        }

    },
);
