#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Partner::Utils qw(convert_design_to_templates convert_design_to_object);
use Test::Partner2::Mock;

use PiConstants qw($BLOCKED_CPM_VALUE);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $got = {$app->context_on_site_rtb->get_bk_data(41443)};

        cmp_deeply(
            $got,
            {
                'rtb_blocks' => {
                    100_000 => {
                        'AdFoxBlock' => '0',
                        'AdType'     => {},
                        'AdTypeSet'  => {
                            'media'             => 1,
                            'media-performance' => 1,
                            'text'              => 1,
                            'video'             => 0,
                            'video-motion'      => 0,
                            'video-performance' => 0
                        },
                        'AltHeight'       => 0,
                        'AltWidth'        => 0,
                        'AlternativeCode' => '<script type="text/javascript"></script>',
                        'BlindLevel'      => 0,
                        'BlockCaption'    => 'В списке1',
                        'BlockModel'      => 'context_on_site_rtb',
                        'Brand'           => {
                            420 => {
                                currency => 'RUB',
                                value    => $BLOCKED_CPM_VALUE,
                            },
                        },
                        'CPMCurrency'     => 'RUB',
                        'CustomBlockData' => {'only-portal-trusted-banners' => 0,},
                        'DSPInfo'         => [],
                        'DSPSettings'     => {
                            'DSP'         => [],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM'      => 0,
                        'DSPType'     => 1,
                        'DirectLimit' => 2,
                        'Geo'         => {
                            1 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            2 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            3 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            17 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            26 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            213 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            225 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            977 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10174 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10645 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10650 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                        },
                        'Height'         => 90,
                        'MultiState'     => 2,
                        'OptimizeType'   => 1,
                        'PageImpOptions' => {
                            'Enable'  => [],
                            'Disable' => [
                                'amp',      'filter-sizes', 'fullscreen', 'ignore-0x0-adaptive-sizes',
                                'rewarded', 'rtbshadow',    'turbo',      'turbo-desktop'
                            ]
                        },
                        PICategoryIAB => {},
                        'RtbDesign'   => {
                            '8' => {
                                'design' => {
                                    'blockId'         => 'R-A-41443-100000',
                                    'borderType'      => 'none',
                                    'callouts'        => JSON::XS::false,
                                    'favicon'         => JSON::XS::false,
                                    'fontSize'        => '1',
                                    'headerBgColor'   => 'FFFFFF',
                                    'horizontalAlign' => JSON::XS::false,
                                    'imagesFirst'     => JSON::XS::false,
                                    'limit'           => '2',
                                    'linksUnderline'  => JSON::XS::true,
                                    'name'            => 'horizontal',
                                    'noSitelinks'     => JSON::XS::true,
                                    'siteBgColor'     => 'FFFFFF',
                                    'textColor'       => '000000'
                                },
                                'name' => 'new template',
                                'type' => 'tga'
                            }
                        },
                        'Width' => 970,
                        'Sizes' => [
                            {
                                Height => 90,
                                Width  => 970,
                            },
                            {
                                Height => 0,
                                Width  => 0,
                            },
                        ],
                        'OrderTags'  => [],
                        'TargetTags' => [],
                    },
                    1 => {
                        'AdFoxBlock' => '0',
                        'AdType'     => {},
                        'AdTypeSet'  => {
                            'media'             => 1,
                            'media-performance' => 1,
                            'text'              => 1,
                            'video'             => 0,
                            'video-motion'      => 0,
                            'video-performance' => 0
                        },
                        'AltHeight'       => 0,
                        'AltWidth'        => 0,
                        'AlternativeCode' => '<script type="text/javascript"></script>',
                        'BlindLevel'      => 0,
                        'BlockCaption'    => 'В списке1',
                        'BlockModel'      => 'context_on_site_rtb',
                        'Brand'           => {
                            420 => {
                                currency => 'RUB',
                                value    => $BLOCKED_CPM_VALUE,
                            },
                        },
                        'CPMCurrency'     => 'RUB',
                        'CustomBlockData' => {'only-portal-trusted-banners' => 0,},
                        'DSPType'         => 1,
                        'DSPInfo'         => [
                            {
                                CPM   => 0,
                                DSPID => 1,
                            },
                        ],
                        'DSPSettings' => {
                            'DSP'         => [1],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM'      => 0,
                        'DirectLimit' => 4,
                        'Geo'         => {
                            1 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            2 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            3 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            17 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            26 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            213 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            225 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            977 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10174 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10645 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                            10650 => {
                                currency => 'RUB',
                                value    => 500000,
                            },
                        },
                        'Height'         => 90,
                        'MultiState'     => 2,
                        'OptimizeType'   => 1,
                        'PageImpOptions' => {
                            'Enable'  => [],
                            'Disable' => [
                                'amp',      'filter-sizes', 'fullscreen', 'ignore-0x0-adaptive-sizes',
                                'rewarded', 'rtbshadow',    'turbo',      'turbo-desktop'
                            ]
                        },
                        PICategoryIAB => {},
                        'RtbDesign'   => {
                            '1' => {
                                'design' => {
                                    'blockId'         => 'R-A-41443-1',
                                    'filterSizes'     => JSON::XS::false,
                                    'horizontalAlign' => JSON::XS::true
                                },
                                'name' => 'default template',
                                'type' => 'media'
                            },
                            '3' => {
                                'design' => {
                                    'blockId'         => 'R-A-41443-1',
                                    'borderType'      => 'none',
                                    'callouts'        => JSON::XS::false,
                                    'favicon'         => JSON::XS::false,
                                    'fontSize'        => '1',
                                    'headerBgColor'   => 'FFFFFF',
                                    'horizontalAlign' => JSON::XS::false,
                                    'imagesFirst'     => JSON::XS::false,
                                    'limit'           => '2',
                                    'linksUnderline'  => JSON::XS::true,
                                    'name'            => 'horizontal',
                                    'noSitelinks'     => JSON::XS::true,
                                    'siteBgColor'     => 'FFFFFF',
                                    'textColor'       => '000000'
                                },
                                'name' => 'default template',
                                'type' => 'tga'
                            },
                            '4' => {
                                'design' => {
                                    'blockId'         => 'R-A-41443-1',
                                    'borderType'      => 'none',
                                    'callouts'        => JSON::XS::false,
                                    'favicon'         => JSON::XS::false,
                                    'fontSize'        => '1',
                                    'headerBgColor'   => 'FFFFFF',
                                    'horizontalAlign' => JSON::XS::false,
                                    'imagesFirst'     => JSON::XS::false,
                                    'limit'           => '4',
                                    'linksUnderline'  => JSON::XS::true,
                                    'name'            => 'horizontal',
                                    'noSitelinks'     => JSON::XS::true,
                                    'siteBgColor'     => 'FFFFFF',
                                    'textColor'       => '000000'
                                },
                                'name' => 'new template',
                                'type' => 'tga'
                            }
                        },
                        'Width' => 970,
                        'Sizes' => [
                            {
                                Height => 90,
                                Width  => 970,
                            },
                            {
                                Height => 0,
                                Width  => 0,
                            },
                        ],
                        'OrderTags'  => [],
                        'TargetTags' => [],
                    }
                }
            },
            'context_on_site_rtb->get_bk_data()'
        );
    },
);
