#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use PiConstants qw( $TECHNICAL_RTB_BLOCK_ID );    # Технический RTB блок (#PI-7517)

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        ####### Partner
        {
            change_cur_user($app, 'mocked-context-adblock-partner');

            my $editable_fields = $app->context_on_site_rtb->get({campaign_id => 41443, id => $TECHNICAL_RTB_BLOCK_ID},
                fields => [qw(editable_fields)]);

            cmp_deeply($editable_fields, undef,
                'No fields of Techical RTB block is allowed for editing for a regular partner - #PI-7517');
        }

        ####### Мanager
        {
            change_cur_user($app, 'mocked-yan-manager');

            my $block_fields = $app->context_on_site_rtb->get({campaign_id => 41443, id => $TECHNICAL_RTB_BLOCK_ID},
                fields => [qw(editable_fields)]);
            my $editable_fields = $block_fields->{'editable_fields'};

            my $not_allowed_for_technical_rtb_block_editable_keys = {
                map {$_ => 1}
                  qw(
                  alternative_code
                  geo
                  articles
                  brands
                  caption
                  direct_block
                  )
            };

            cmp_deeply([grep {$not_allowed_for_technical_rtb_block_editable_keys->{$_}} sort keys %$editable_fields],
                [], 'Some fields is not allowed for editing for a techical RTB block - #PI-7517');
        }

    },
);
