#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Fixture;

use Test::Deep;

use qbit;

use lib::abs;

my @block_fixtures = (
    'partner_context_rtb_block_with_mincpm_strategy',
    'partner_context_rtb_block_with_max_revenue_strategy',
    'partner_context_rtb_block_with_separate_cpm_strategy',
);

my %tests = (
    mincpm => {
        filter   => {strategy => 0},
        expected => ['partner_context_rtb_block_with_mincpm_strategy',],
    },
    max_revenue => {
        filter   => {strategy => 1},
        expected => ['partner_context_rtb_block_with_max_revenue_strategy',],
    },
    separate_cpm => {
        filter   => {strategy => 3},
        expected => ['partner_context_rtb_block_with_separate_cpm_strategy',],
    },
    mincpm_equals => {
        filter   => {mincpm => 20},
        expected => ['partner_context_rtb_block_with_mincpm_strategy',],
    },
    mincpm_greater => {
        filter   => [mincpm => '>' => 10],
        expected => ['partner_context_rtb_block_with_mincpm_strategy',],
    },
    mincpm_less => {
        filter   => [mincpm => '<' => 30],
        expected => ['partner_context_rtb_block_with_mincpm_strategy',],
    },
    mincpm_greater => {
        filter   => [mincpm => '>' => 10],
        expected => ['partner_context_rtb_block_with_mincpm_strategy',],
    },
    text_not_blocked => {
        filter   => {text_blocked => 0},
        expected => ['partner_context_rtb_block_with_separate_cpm_strategy',],
    },
    media_blocked => {
        filter   => {media_blocked => 1},
        expected => ['partner_context_rtb_block_with_separate_cpm_strategy',],
    },
);

my %dsp_name_by_id;

run_tests(
    sub {
        my ($app) = @_;

        my $blocks = get_fixtures_hash(@block_fixtures);

        my %block_name_by_id;

        for my $block_name (@block_fixtures) {
            $block_name_by_id{$blocks->{$block_name}{campaign_id}}{$blocks->{$block_name}{id}} = $block_name;
        }

        for my $test_name (sort keys(%tests)) {
            my ($filter, $expected) = @{$tests{$test_name}}{qw(filter expected)};
            my $result =
              [map {$block_name_by_id{$_->{page_id}}{$_->{id}}}
                  @{$app->context_on_site_rtb->get_all(fields => [qw(page_id id)], filter => $filter)}];
            cmp_deeply($result, $expected, $test_name);
        }
    },
    fill_databases => 0,
    fixtures       => [@block_fixtures],
);
