#!/usr/bin/perl -w

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply);

use Test::MockObject::Extends::Easy;
use Test::Partner::Utils qw( get_new_direct_context );

run_tests(
    sub {
        my ($app) = @_;

        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});

        $app->api_bk->mock(
            'call',
            sub {
                my ($self, $method, $data) = @_;
                is($method, 'EditPage');

                my $page_id = $data->{0}->{'PageID'};

                return [
                    {
                        '0' => {
                            'Error'    => '0',
                            'PageID'   => $page_id,
                            'ErrorStr' => ''
                        }
                    }
                ];
            }
        );

        my $ids = $app->context_on_site_direct->_split_id(
            $app->context_on_site_direct->add(
                get_new_direct_context({campaign_id => 1, comment => 'The comment', url_background_color => 'ABCDEF'})
            )
        );

        cmp_deeply(
            $ids,
            {
                campaign_id => 1,
                id          => 1,
            },
            'Got correct answer from context_on_site_direct->add( ... )',
        );

        my $data = $app->context_on_site_direct->get_all(
            filter => $ids,
            fields => [qw(caption comment)],
        );

        cmp_deeply(
            $data,
            [
                {
                    caption => 'Block 1',
                    comment => 'The comment',
                }
            ],
            'Got expected result from get_all()',
        );
    }
);
__END__
