#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply);

run_tests(
    sub {
        my ($app) = @_;

        my $m = $app->context_on_site_campaign;

        is($m->get_multistate_name(0),  gettext('New'));
        is($m->get_multistate_name(81), pgettext('Campaign status', 'Working'));
        is($m->get_multistate_name(82), pgettext('Campaign status', 'Testing'));
        is($m->get_multistate_name(92), pgettext('Campaign status', 'Stopped'));

        # private => TRUE
        is($m->get_multistate_name(0, private => TRUE), gettext('New'));
        is(
            $m->get_multistate_name(81, private => TRUE),
            join(".\n",
                pgettext('Campaign status', 'Working'),
                pgettext('Campaign status', 'Added to Balance'),
                pgettext('Campaign status', 'Check statistics'),
            )
          );

        is(
            $m->get_multistate_name(82, private => TRUE),
            join(".\n",
                pgettext('Campaign status', 'Testing'),
                pgettext('Campaign status', 'Added to Balance'),
                pgettext('Campaign status', 'Check statistics'),
            )
          );
        is(
            $m->get_multistate_name(92, private => TRUE),
            join(".\n",
                pgettext('Campaign status', 'Stopped'),
                pgettext('Campaign status', 'Archived'),
                pgettext('Campaign status', 'Added to Balance'),
                pgettext('Campaign status', 'Check statistics'),
            )
          );

        # private => FALSE
        is($m->get_multistate_name(0,  private => FALSE), gettext('New'));
        is($m->get_multistate_name(81, private => FALSE), pgettext('Campaign status', 'Working'));
        is($m->get_multistate_name(82, private => FALSE), pgettext('Campaign status', 'Testing'));
        is($m->get_multistate_name(92, private => FALSE), pgettext('Campaign status', 'Stopped'));

        # impossible multistate
        my $all_multistates = $m->get_multistates();
        ok(!exists($all_multistates->{2}), 'There is no multistate 2');
        is(
            $m->get_multistate_name(2, private => TRUE),
            pgettext('Campaign status', 'Testing'),
            'But it is possible to get name for multistate 2'
          );
    }
);
