#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences qw(eq_or_diff);
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_adfox mock_agreement_checker);
use Test::Partner::Utils qw(use_perl_do_actions);
use Test::More tests => 2 + 8;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        use_perl_do_actions($app, 'mobile_app_rtb');

        my $fired_notifications;

        mock_adfox(
            $app,
            sub {
                my ($sub, %opts) = @_;
                push @$fired_notifications, [$sub => \%opts];
            }
        );
        mock_agreement_checker($app);

        my $not_mobmed_block = {campaign_id => 43569,  id => 1};
        my $mobmed_block     = {campaign_id => 153980, id => 2};

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($not_mobmed_block, edit => caption => 'not mobile mediation',);
        eq_or_diff($fired_notifications, [], 'no notification for edit block w/o place_id');

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action(
            $mobmed_block, edit => caption => 'Блок RTB',
            show_video => 0,
        );
        eq_or_diff($fired_notifications, [], 'no notification if caption is same');

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($mobmed_block, edit => caption => 'renamed Блок RTB',);
        eq_or_diff(
            $fired_notifications,
            [[update_block_name => {place_id => 555, new_name => 'renamed Блок RTB'}]],
            'update_block_name executed'
        );

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($mobmed_block, edit => show_video => 0,);
        eq_or_diff($fired_notifications, [], 'no notifications if caption not supplied');

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($mobmed_block, 'delete');
        eq_or_diff($fired_notifications, [[delete_block => {place_id => 555}]], 'delete_block notification');

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($not_mobmed_block, 'delete');
        eq_or_diff($fired_notifications, [], 'no notification for block delete w/o place_id');

        $fired_notifications = [];
        $app->mobile_app_rtb->do_action($mobmed_block, 'restore');
        eq_or_diff($fired_notifications, [], 'no notification for restore_block');

        eq_or_diff(
            $app->mobile_app_rtb->get($mobmed_block, fields => [qw(place_id)]),
            {place_id => undef},
            'place_id cleared on restored block'
        );

    },
);
