#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';
use fields qw();

use Test::Partner2::Simple;

use Test::MockObject::Extends;

use Test::More;
use Test::Deep;

use qbit;

use PiConstants qw($DSP_DIRECT_ID @VIDEO_INTERSTITIAL_DSPS @VIDEO_BANNER_DSPS $INTERNAL_DSP_TAGS $ADINSIDE_CLIENT_ID);

my $PAGE_ID     = 43569;
my $USER_ID     = 1011;
my @MOBILE_DSPS = ($DSP_DIRECT_ID, 2563084, 2563106, 2563150, 2563169, 2563197, 2563200);

my $TESTS = [
    {
        name   => 'banner',
        params => {page_id => $PAGE_ID, block_type => 'banner', show_video => FALSE},
        expected => {'id' => [@MOBILE_DSPS]},
    },
    {
        name   => 'banner, show_video not ignore',
        params => {page_id => $PAGE_ID, block_type => 'banner', show_video => TRUE},
        expected => {'id' => [@MOBILE_DSPS, @VIDEO_BANNER_DSPS]},
    },
    {
        name => 'banner, is_yandex_page & business_unit',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 1})},
        params   => {page_id => $PAGE_ID, block_type => 'banner', show_video => FALSE},
        expected => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name        => 'banner, business_unit',
        pre_process => sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => 111111, business_unit => 1})},
        params      => {page_id => $PAGE_ID, block_type => 'banner', show_video => FALSE},
        expected    => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name => 'banner, is_yandex_page',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 0})},
        params   => {page_id => $PAGE_ID, block_type => 'banner', show_video => FALSE},
        expected => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name   => 'native',
        params => {page_id => $PAGE_ID, block_type => 'native', show_video => FALSE},
        expected => {'id' => [$DSP_DIRECT_ID]},
    },
    {
        name   => 'native, show_video ignore',
        params => {page_id => $PAGE_ID, block_type => 'native', show_video => TRUE},
        expected => {'id' => [$DSP_DIRECT_ID]},
    },
    {
        name => 'native, is_yandex_page & business_unit',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 1})},
        params   => {page_id => $PAGE_ID, block_type => 'native', show_video => TRUE},
        expected => {
            'id'  => [$DSP_DIRECT_ID],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name        => 'native, business_unit',
        pre_process => sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => 111111, business_unit => 1})},
        params      => {page_id => $PAGE_ID, block_type => 'native', show_video => TRUE},
        expected    => {
            'id'  => [$DSP_DIRECT_ID],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name => 'native, is_yandex_page',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 0})},
        params   => {page_id => $PAGE_ID, block_type => 'native', show_video => TRUE},
        expected => {
            'id'  => [$DSP_DIRECT_ID],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name   => 'interstitial, show_video = FALSE',
        params => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => FALSE},
        expected => {'id' => [@MOBILE_DSPS]},
    },
    {
        name => 'interstitial, show_video = FALSE (is_yandex_page & business_unit)',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 1})},
        params   => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => FALSE},
        expected => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name        => 'interstitial, show_video = FALSE (business_unit)',
        pre_process => sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => 111111, business_unit => 1})},
        params      => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => FALSE},
        expected    => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name => 'interstitial, show_video = FALSE (is_yandex_page)',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 0})},
        params   => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => FALSE},
        expected => {
            'id'  => [@MOBILE_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name   => 'interstitial, show_video = TRUE',
        params => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => TRUE},
        expected => {'id' => [@MOBILE_DSPS, @VIDEO_INTERSTITIAL_DSPS]},
    },
    {
        name => 'interstitial, show_video = TRUE (is_yandex_page & business_unit)',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 1})},
        params   => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => TRUE},
        expected => {
            'id'  => [@MOBILE_DSPS, @VIDEO_INTERSTITIAL_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name        => 'interstitial, show_video = TRUE (business_unit)',
        pre_process => sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => 111111, business_unit => 1})},
        params      => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => TRUE},
        expected    => {
            'id'  => [@MOBILE_DSPS, @VIDEO_INTERSTITIAL_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
    {
        name => 'interstitial, show_video = TRUE (is_yandex_page)',
        pre_process =>
          sub {$_[0]->partner_db->users->edit($USER_ID, {client_id => $ADINSIDE_CLIENT_ID, business_unit => 0})},
        params   => {page_id => $PAGE_ID, block_type => 'interstitial', show_video => TRUE},
        expected => {
            'id'  => [@MOBILE_DSPS, @VIDEO_INTERSTITIAL_DSPS],
            'tag' => $INTERNAL_DSP_TAGS
        },
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->mobile_app_rtb;
        $app->{'mobile_app_rtb'} = Test::MockObject::Extends->new($app->{'mobile_app_rtb'});

        my ($name, $expected);
        $app->mobile_app_rtb->mock(
            '_get_dsps_by_filter',
            sub {
                cmp_deeply($_[1], $expected, $name);
            }
        );

        foreach my $t (@$TESTS) {
            if ($t->{'pre_process'}) {
                $t->{'pre_process'}->($app);
            } else {
                $app->partner_db->users->edit($USER_ID, {client_id => 11011, business_unit => 0});
            }

            $name     = $t->{'name'};
            $expected = $t->{'expected'};

            $app->mobile_app_rtb->get_default_dsps($t->{'params'});
        }
    },
);
