#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Deep;

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_balance mock_bk mock_mailer);

use Test::Partner::Utils qw(get_new_mobile_rtb get_bk_data);

use PiConstants qw(@VIDEO_BANNER_DSPS @VIDEO_INTERSTITIAL_DSPS $DSP_BANNER_FORMAT_ID);

our $MOBILE_APP_SETTINGS_ID = 43569;
our $PAGE_ID                = 43569;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $multistate = $app->dsp->get_multistates_by_filter(
            'created_in_bk and (created_in_pi or not_need_create_in_pi) and linked_in_balance and not deleted')->[0];
        $app->partner_db->dsp->add_multi([map {{id => $_, multistate => $multistate}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_type->add_multi([map {{dsp_id => $_, type_id => 2}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_format->add_multi(
            [map {{dsp_id => $_, format_id => $DSP_BANNER_FORMAT_ID}} @VIDEO_INTERSTITIAL_DSPS]);

        change_cur_user($app, 'mocked-yan-manager');

        foreach my $block_type (qw(banner native)) {

            my $public_id = $app->mobile_app_rtb->add(
                get_new_mobile_rtb({page_id => $PAGE_ID, block_type => $block_type, dsps => [1], show_video => 0}));
            my $block_id = $public_id;
            $block_id =~ s/R-M-\d+-//;

            foreach my $option_value (0 .. 1) {
                $app->mobile_app_rtb->do_action($public_id, 'edit', show_video => $option_value);
                my $bk_data = get_bk_data($app->mobile_app_settings, {id => $MOBILE_APP_SETTINGS_ID});

                cmp_deeply(
                    $bk_data->{'rtb_blocks'}{$block_id}{'AdTypeSet'},
                    {
                        'media'             => $block_type eq 'banner' ? 1 : 0,
                        'media-performance' => $block_type eq 'banner' ? 1 : 0,
                        'text'              => 1,
                        'video'             => $option_value,
                    },
                    "$block_type AdTypeSet: show_video = $option_value"
                );

                cmp_deeply(
                    [map {$_->{'DSPID'}} @{$bk_data->{'rtb_blocks'}{$block_id}{'DSPInfo'}}],
                    [1, $option_value ? ($block_type eq 'banner' ? @VIDEO_BANNER_DSPS : ()) : ()],
                    "$block_type DSPInfo: show_video = $option_value"
                );
            }
        }

    },
    init => [qw(mobile_app)]
);

sub mock_app {
    my ($app) = @_;

    {
        no strict 'refs';
        no warnings 'redefine';

        *{'Application::Model::Product::AN::MobileApp::send_letter'} = sub { };
    }

    mock_balance($app);

    mock_bk($app);

    mock_mailer($app);
}
