#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_utils_partner2 mock_balance mock_mailer);

use qbit;
use Test::Partner::Utils qw(get_new_mobile_app get_new_mobile_rtb get_bk_data);

use PiConstants qw(@VIDEO_INTERSTITIAL_DSPS $DSP_BANNER_FORMAT_ID);

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $multistate = $app->dsp->get_multistates_by_filter(
            'created_in_bk and (created_in_pi or not_need_create_in_pi) and linked_in_balance and not deleted')->[0];
        $app->partner_db->dsp->add_multi([map {{id => $_, multistate => $multistate}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_type->add_multi([map {{dsp_id => $_, type_id => 2}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_format->add_multi(
            [map {{dsp_id => $_, format_id => $DSP_BANNER_FORMAT_ID}} @VIDEO_INTERSTITIAL_DSPS]);

        change_cur_user($app, 'mocked-mobile-app-partner');

        my $mobile_app_id = $app->mobile_app->add(
            get_new_mobile_app({store_url => 'https://play.google.com/store/apps/details?id=com.testik'}));

        my $tmp_rights = $app->add_tmp_rights('do_mobile_app_approve');
        $app->mobile_app->do_action($mobile_app_id, 'approve');
        undef($tmp_rights);

        my $mobile_app_settings_id =
          $app->mobile_app_settings->add(app_id => $mobile_app_id, caption => 'Test mobile campaign');
        my $page_id = $app->mobile_app_settings->get($mobile_app_settings_id, fields => [qw(page_id)])->{'page_id'};

        my $public_id =
          $app->mobile_app_rtb->add(get_new_mobile_rtb({context_page_id => $page_id, block_type => 'interstitial'}));

        my $bk_data = get_bk_data($app->mobile_app_settings, {id => $mobile_app_settings_id});

        cmp_deeply(
            $bk_data->{'rtb_blocks'}{'1'}{'AdTypeSet'},
            {
                'media'             => 1,
                'media-performance' => 1,
                'text'              => 1,
                'video'             => 1,
                'video-motion'      => 1,
                'video-performance' => 1,
            },
            'AdTypeSet: show_video = 1'
        );

        cmp_deeply(
            [map {$_->{'DSPID'}} @{$bk_data->{'rtb_blocks'}{'1'}{'DSPInfo'}}],
            [1, @VIDEO_INTERSTITIAL_DSPS],
            'DSPInfo: show_video = 1'
        );
    },
    init => [qw(mobile_app)]
);

sub mock_app {
    my ($app) = @_;

    {
        no strict 'refs';
        no warnings 'redefine';

        *{'Application::Model::Product::AN::MobileApp::send_letter'} = sub { };
    }

    mock_utils_partner2($app);

    mock_balance($app);

    mock_mailer($app);
}
