#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;
use qbit;

# all multistates currently found in production DB
my @mults =
  (0, 8, 32, 33, 34, 36, 40, 44, 164, 172, 289, 290, 292, 2048, 2056, 2560, 4096, 4104, 4132, 4140, 4260, 4352);

run_tests(
    sub {
        my ($app) = @_;
        my $model = $app->mobile_app_settings;

        my $got = {};

        my @single_states = map {$_->{id}} $model->get_single_states;

        $got->{single2mult} = {$model->_single_states_to_filter_strings};

        for my $mult (@mults) {
            (my $mult_name = $model->get_multistate_name($mult)) =~ s/\n/ /g;
            $got->{mult2single}{$mult} = [$mult_name, $model->_multistate_to_single_state($mult)];
        }

        my $expected = get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $expected, 'compare mapping');

    },
    dont_create_database => 1
);
