use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More tests => 4;
use Test::Deep;

sub check_initial_data {
    my ($app) = @_;

    my $initial_data = $app->mobile_app_settings->get_all(
        fields => [
            qw(
              id
              context_page_id
              caption
              mobile_app_rtb_count
              )
        ],
        filter => {id => 43569},
    );

    my $expected_data = [
        {
            id                   => 43569,
            context_page_id      => 43569,
            caption              => 'test',
            mobile_app_rtb_count => 1,        # PI-9001
        },
    ];

    cmp_deeply($initial_data, $expected_data, 'Got expected initial data',);
}

sub check_change_caption {
    my ($app) = @_;

    $app->mobile_app_settings->do_action(43569, 'edit', caption => 'test2');

    my $data_after_change = $app->mobile_app_settings->get_all(
        fields => [qw(id context_page_id caption)],
        filter => {id => 43569},
    );

    my $expected_data = [
        {
            id              => 43569,
            context_page_id => 43569,
            caption         => 'test2',
        },
    ];

    cmp_deeply($data_after_change, $expected_data, 'Got expected data after change',);
}

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);

        change_cur_user($app, 'mocked-yan-manager');

        check_initial_data($app);
        check_change_caption($app);

    },
);
