#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences qw(eq_or_diff);
use Test::More tests => 2 + 8;

use Test::Partner2::Mock qw(mock_adfox mock_balance mock_agreement_checker);
use Test::Partner2::Simple;
use Test::Partner::Utils qw(use_perl_do_actions);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        use_perl_do_actions($app, 'mobile_app_rtb');

        my $fired_notifications;

        mock_adfox(
            $app,
            sub {
                my ($sub, %opts) = @_;
                push @$fired_notifications, [$sub => \%opts];
            }
        );
        mock_balance($app);
        mock_agreement_checker($app);

        my $not_mobmed_page = {id => 43569};
        my $mobmed_page     = {id => 153980};

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($not_mobmed_page, edit => caption => 'not mobile mediation',);
        eq_or_diff($fired_notifications, [], 'no notification for edit page w/o mobmed');

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($mobmed_page, edit => caption => 'test',);
        eq_or_diff($fired_notifications, [], 'no notification if caption is same');

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($mobmed_page, edit => caption => 'test2',);
        eq_or_diff(
            $fired_notifications,
            [[update_page_name => {page_id => $mobmed_page->{id}, new_name => 'test2'}]],
            'update_page_name executed'
        );

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($not_mobmed_page, 'stop');
        eq_or_diff($fired_notifications, [], 'no notification for stop page w/o mobmed');

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($not_mobmed_page, 'start');
        eq_or_diff($fired_notifications, [], 'no notification for start page w/o mobmed');

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($mobmed_page, 'stop');
        eq_or_diff(
            $fired_notifications,
            [[start_stop_page => {page_id => $mobmed_page->{id}, is_started => FALSE}]],
            'start_stop_page executed on stop'
        );

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($mobmed_page, 'start');
        eq_or_diff(
            $fired_notifications,
            [[start_stop_page => {page_id => $mobmed_page->{id}, is_started => TRUE}]],
            'start_stop_page executed on start'
        );

        $app->mobile_app_settings->do_action($mobmed_page, 'stop');

        $fired_notifications = [];
        $app->mobile_app_settings->do_action($mobmed_page, 'delete');
        eq_or_diff($fired_notifications, [[delete_block => {place_id => 555}]], 'delete_block for inner blocks');
    },
);
