#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Deep;

use qbit;
use Test::Partner2::Simple;

my @data =
  qw(app_id caption comment ignore_domain_check login moneymap order_tags performance_tgo_disable picategories target_tags);

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-manager');
        cmp_bag([keys %{$app->mobile_app_settings->get_add_fields()}], \@data, "add fields ok");

        change_cur_user($app, 'mocked-yndx-adfox');
        cmp_bag([keys %{$app->mobile_app_settings->get_add_fields()}], [@data, 'is_mobile_mediation'], "add fields ok");
    },
);
