#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use DDP;
use Test::Most;
use Test::More;
use Test::Deep;
use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_balance($app);

        throws_ok {$app->mobile_app->add()}
        'Exception::Validator::Errors',
          'exception on missed fields is ok';

        my $data = [
            {
                login => 'mocked-mobile-app-partner',
                data  => {store_url => 'https://play.google.com/store/apps/details?id=test.test'}
            },
            {
                login => 'tutby-partner-with-agreement',
                data  => {store_url => 'https://play.google.com/store/apps/details?id=com.test'}
            },
            {
                login => 'mocked-yndx-adfox',
                data  => {
                    store_url           => 'https://play.google.com/store/apps/details?id=test.test',
                    is_mobile_mediation => 1,
                    login               => 'mocked-mobile-mediation-partner'
                }
            },
        ];

        my $app_id_by_login;
        foreach my $row (@$data) {
            change_cur_user($app, $row->{'login'});

            my $app_id = $app->mobile_app->add(get_new_mobile_app($row->{data}));

            my $added_mobile_app = $app->mobile_app->get($app_id);
            unless ($added_mobile_app->{store_id}) {
                fail('store_id must be filled');
            } else {
                # Не проверяем так как он все равно возвращается моком
                # достаточно проверить что там что то есть
                delete($added_mobile_app->{store_id});
            }
            cmp_deeply(
                $added_mobile_app,
                {
                    'id' => $app_id,
                    # 'store_id'  => 'test.test',
                    'store_url' => $row->{data}{store_url},
                    'type'      => 1,
                },
                " - add mobile app ok for $row->{login}"
            );

            $app_id_by_login->{$row->{'login'}} = $app_id;
        }

        is(
            $app_id_by_login->{'mocked-mobile-app-partner'},
            $app_id_by_login->{'mocked-yndx-adfox'},
            'same app has same id'
          );

        change_cur_user($app, 'mocked-mobile-mediation-partner');
        cmp_deeply(
            $app->mobile_app->get(
                $app_id_by_login->{'mocked-yndx-adfox'},
                fields => [qw(id store_id store_url type is_mobile_mediation)]
            ),
            {
                'id'                  => $app_id_by_login->{'mocked-yndx-adfox'},
                'store_id'            => 'test.test',
                'store_url'           => 'https://play.google.com/store/apps/details?id=test.test',
                'type'                => 1,
                'is_mobile_mediation' => 1,
            },
            ' - is_mobile_mediation are set'
        );

        change_cur_user($app, 'tutby-cop');

        cmp_deeply(
            $app->mobile_app->get(
                $app_id_by_login->{'tutby-partner-with-agreement'},
                fields => [qw(id store_id store_url type is_mobile_mediation)]
            ),
            {
                'id'                  => $app_id_by_login->{'tutby-partner-with-agreement'},
                'store_id'            => 'com.test',
                'store_url'           => 'https://play.google.com/store/apps/details?id=com.test',
                'type'                => 1,
                'is_mobile_mediation' => 0,
            },
            ' - add mobile app ok for tutby-cop'
        );
    },
);
