#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use DDP;
use Test::Most;
use Test::More;
use Test::Deep;
use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils;

use qbit;

my $MAIL_REQUEST_COUNT;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_balance($app);
        mock_zora($app);
        mock_mailer($app);
        mock_utils_partner2($app);

        my $call_count;

        {
            require Application::Model::Queue;
            no warnings 'redefine';
            no strict 'refs';
            *{'Application::Model::Queue::add'} = sub {
                my ($self, %opts) = @_;
                $call_count->{$opts{params}{active}}++;
            };
        }

        change_cur_user($app, 'mocked-mobile-app-partner');
        my $app1 = $app->mobile_app->add(
            get_new_mobile_app({store_url => 'https://play.google.com/store/apps/details?id=test.test.one'}));
        my $app2 = $app->mobile_app->add(
            get_new_mobile_app({store_url => 'https://play.google.com/store/apps/details?id=test.test.two'}));

        change_cur_user($app, 'mocked-moderator');
        $app->mobile_app->do_action($app1, 'approve');
        $app->mobile_app->do_action($app2, 'reject');

        ok(!$call_count, 'no calls');

        change_cur_user($app, 'mocked-yndx-adfox');
        my $app3 = $app->mobile_app->add(
            get_new_mobile_app(
                {
                    store_url           => 'https://play.google.com/store/apps/details?id=test.test.three',
                    is_mobile_mediation => 1,
                    login               => 'mocked-mobile-app-partner',
                }
            )
        );
        my $app4 = $app->mobile_app->add(
            get_new_mobile_app(
                {
                    store_url           => 'https://play.google.com/store/apps/details?id=test.test.four',
                    is_mobile_mediation => 1,
                    login               => 'mocked-mobile-app-partner',
                }
            )
        );

        change_cur_user($app, 'mocked-moderator');
        $app->mobile_app->do_action($app3, 'approve');
        $app->mobile_app->do_action($app4, 'reject');

        is($call_count->{1}, 1, 'has calls with 1');
        is($call_count->{0}, 1, 'has calls with 0');

        change_cur_user($app, 'mocked-yndx-adfox');
        my $app5 = $app->mobile_app->add(
            get_new_mobile_app(
                {
                    store_url           => 'https://play.google.com/store/apps/details?id=test.test.five',
                    login               => 'mocked-mobile-app-partner',
                    is_mobile_mediation => 1
                }
            )
        );

        change_cur_user($app, 'mocked-mobile-app-partner');
        my $mobile_app_settings_id = $app->mobile_app_settings->add(app_id => $app5, caption => 'Test mobile caption');

        $app->{'mobile_app_settings'} = Test::MockObject::Extends->new($app->{'mobile_app_settings'});
        $app->mobile_app_settings->mock(do_action => sub { });
        $app->mobile_app_settings->mock(
            get_all => sub {
                return [
                    {
                        caption             => 'Test mobile caption',
                        is_mobile_mediation => 1,
                        multistate          => 2064,
                        owner_id            => 1011
                    }
                ];
            }
        );

        $app->mail_notification;
        $app->{'mail_notification'} = Test::MockObject::Extends->new($app->{'mail_notification'});
        $app->mail_notification->mock(
            add => sub {
                my ($self, %opts) = @_;

                $MAIL_REQUEST_COUNT++;

                if ($MAIL_REQUEST_COUNT == 1) {
                    cmp_deeply(
                        \%opts,
                        {
                            opts => {
                                values => {
                                    caption => "Test mobile caption",
                                    user_id => 1011
                                }
                            },
                            type    => 13,
                            user_id => 1011
                        },
                        'got expected first mobile_mediation notification sender request',
                    );
                }
            }
        );

        change_cur_user($app, 'mocked-moderator');
        $app->mobile_app->do_action($app5, 'approve');
    },
    mock_http => 1
);
