#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use DDP;
use Test::Most;
use Test::More;
use Test::Deep;
use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use Test::Partner::Utils;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my ($is_ok, $details) =
          $app->qbit_validator_checker->check_all_elements_in_model(is_send_to_juggler => 0, accessor => 'mobile_app');

        is($is_ok, 1, 'validation ok');

        $app->partner_db->mobile_app->edit(1, {opts => {json_set => ['opts', \'$.apple_store_id', \123]},});

        ($is_ok, $details) =
          $app->qbit_validator_checker->check_all_elements_in_model(is_send_to_juggler => 0, accessor => 'mobile_app');

        is($is_ok, 0, 'validation fails');
        is_deeply(
            $details->{error_elements},
            [
                {
                    'error_fields' => {
                        'apple_store_id' => {
                            'msg'   => 'Invalid Apple Store ID "123"',
                            'path'  => ['apple_store_id'],
                            'value' => '123'
                        }
                    },
                    'pk' => {'id' => 1}
                }
            ],
            'validation fails on correct element'
        );

    },
);
