#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::More;
use Test::Deep;
use Test::Exception;
use Test::MockObject::Extends;
use Test::Partner::DB::Mock;
use Test::Partner2::Mock;

use qbit;

my $ID = 111161;

my $TEST_DATA = [
    {
        method     => 'cron_init_campaigns',
        args       => [],
        status     => 'testing',
        expected   => TRUE,
        tmp_rights => ['do_search_on_site_register_in_balance', 'do_search_on_site_start_testing'],
    },
    {
        method     => 'do_action',
        args       => [$ID, 'stop'],
        status     => 'stopped',
        expected   => TRUE,
        tmp_rights => ['do_search_on_site_stop'],
    },
    {
        method   => 'do_action',
        args     => [$ID, 'delete'],
        status   => 'deleted',
        expected => TRUE,
    },
    {
        method   => 'do_action',
        args     => [$ID, 'restore'],
        status   => 'deleted',
        expected => FALSE,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

        $app->api_http_gozora;
        $app->{'api_http_gozora'} = Test::MockObject::Extends->new($app->{'api_http_gozora'});

        $app->api_balance->mock('create_or_update_place', sub {1});

        $app->api_http_gozora->mock('get_page_inf', sub {{body_length_bytes => 1}});

        foreach my $test_case (@$TEST_DATA) {
            my $tmp_rights;
            if ($test_case->{tmp_rights}) {
                $tmp_rights = $app->add_tmp_rights(@{$test_case->{tmp_rights}});
            }

            my $method = $test_case->{method};
            my @args   = @{$test_case->{args}};
            $app->search_on_site_campaign->$method(@args);

            is(
                $app->search_on_site_campaign->check_multistate_flag(
                    $app->search_on_site_campaign->get($ID, fields => ['multistate'])->{'multistate'},
                    $test_case->{status}
                ),
                $test_case->{expected},
                'Check status ' . $test_case->{status},
              );
        }
    },
    user => 'mocked-yan-partner'
);
