use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_zora mock_mailer);
use Test::Partner::Utils qw(get_new_site);

use Test::More;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_zora($app);
        mock_mailer($app);

        my $site_id = $app->site->add(get_new_site({login_owner => 'mocked-yan-partner'}));

        my $site_before = $app->site->get($site_id, fields => [qw(id multistate)]);
        ok(!$app->site->check_multistate_flag($site_before->{'multistate'}, 'approved'),
            "In the beginning site $site_id is not approved");

        $app->site->do_action($site_id, 'approve');

        my $site_after = $app->site->get($site_id, fields => [qw(id multistate multistate_name)]);
        ok($app->site->check_multistate_flag($site_after->{'multistate'}, 'approved'),
            "After the change site $site_id is approved");

        eval {$app->site->do_action($site_id, 'approve');};

        ok($@, 'Exception throw');

        is(ref($@), 'Exception::Validation::BadArguments', 'Correctly exception class');

        is($@->message, gettext('You cannot approve this site because the site approved'), 'Correctly message');
    },
);
