use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Exception;
use qbit;

use DDP;

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};

        mock_mailer($app);

        my $domain_id = 1;

        my $site_before = $app->site->get($domain_id, fields => [qw(id multistate)]);
        ok(!$app->site->check_multistate_flag($site_before->{'multistate'}, 'rejected'),
            "In the beginning site $domain_id is not rejected");

        my $context_before = $app->context_on_site_campaign->get_all(
            fields => [qw(id domain_id multistate multistate_name)],
            filter => {domain_id => $domain_id,},
        );
        my @context_working_before;
        foreach my $c (@$context_before) {
            ok(!$app->context_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'rejected'),
                "In the beginning context campaign $c->{'id'} is not rejected");
            push @context_working_before, $c->{'id'}
              if $app->context_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'working');
        }
        is(scalar(@context_working_before), 3, 'has working context');

        my $search_before = $app->search_on_site_campaign->get_all(
            fields => [qw(id domain_id multistate multistate_name)],
            filter => {domain_id => $domain_id,},
        );
        foreach my $c (@$search_before) {
            ok(!$app->search_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'rejected'),
                "In the beginning search campaign $c->{'id'} is not rejected");
        }

        $app->site->do_action($domain_id, 'reject');

        my $site_after = $app->site->get($domain_id, fields => [qw(id multistate multistate_name)]);
        ok($app->site->check_multistate_flag($site_after->{'multistate'}, 'rejected'),
            "After the change site $domain_id is rejected");

        my $context_after = $app->context_on_site_campaign->get_all(
            fields => [qw(id domain_id multistate multistate_name)],
            filter => {domain_id => $domain_id,},
        );
        my @context_working_after;
        foreach my $c (@$context_after) {
            ok($app->context_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'rejected'),
                "After the change context campaign $c->{'id'} is rejected");
            push @context_working_after, $c->{'id'}
              if $app->context_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'working');
        }

        my $search_after = $app->search_on_site_campaign->get_all(
            fields => [qw(id domain_id multistate multistate_name)],
            filter => {domain_id => $domain_id,},
        );
        foreach my $c (@$search_after) {
            ok($app->search_on_site_campaign->check_multistate_flag($c->{'multistate'}, 'rejected'),
                "After the change search campaign $c->{'id'} is rejected");
        }

        ok(@context_working_after == 0, 'has not working context');

        throws_ok {
            $app->context_on_site_campaign->do_action($context_working_before[0], 'start');
        }
        qw/Exception::Multistate::BadAction/, 'cannot start after reject';
    },
);
