use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More;
use Test::Exception;
use Test::Partner::Utils;
use qbit;

use DDP;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);
        my $start_page_id = 99393;
        my $calls_counter = 0;

        no strict 'refs';
        no warnings 'redefine';
        local *{'QBit::Application::Model::API::Yandex::HTTPGoZora::is_site_working'} = sub {
            return 1;
        };
        local *{'Application::Model::API::Yandex::UtilsPartner2::get_next_page_id'} = sub {
            $start_page_id += 1;
            return $start_page_id;
        };
        local *{'Application::Model::Product::AN::Site::send_letter_after_reject'} = sub {
            my ($self, %opts) = @_;
            $calls_counter += 1;
            is($opts{'user_id'}, 1009, 'Called with wrong owner_id');
        };

        change_cur_user($app, 'mocked-yan-partner');
        my $site_id1 = $app->site->add(get_new_site());
        change_cur_user($app, 'mocked-yan-partner-wo');
        my $site_id2 = $app->site->add(get_new_site());
        is($site_id1, $site_id2, 'Generated sites are not equals');

        change_cur_user($app, 'mocked-yan-partner');
        $app->context_on_site_campaign->add(
            caption   => 'caption',
            domain_id => $site_id1,
        );

        change_cur_user($app, 'mocked-yan-partner-wo');

        my $campaign_id = $app->context_on_site_campaign->add(
            caption   => 'caption',
            domain_id => $site_id2,
        );

        $app->context_on_site_campaign->do_action($campaign_id, 'delete');

        change_cur_user($app, 'mocked-yan-manager');
        $app->site->do_action($site_id1, 'reject');

        is($calls_counter, 1, 'send_letter_after_reject was called wrong times');
    },
    init => [qw(api_utils_partner2 api_http_gozora site)],
);
