#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::Deep;

use qbit;

my $DATA = [
    {
        testname => 'ContextOnSite::Campaign',
        model    => 'context_on_site_campaign',
        id       => 41443,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        foreach my $testdata (@$DATA) {
            my ($model, $id, $testname) = @$testdata{qw( model  id  testname )};

            change_cur_user($app, 'mocked-yan-partner');

            subtest(
                $testname => sub {

                    # Чтобы не было проблем с графом статусов
                    $app->partner_db->$model->edit($id, {multistate => 0});

                    # Подводим к нужному статусу
                    $app->$model->do_action($id, 'add');
                    $app->$model->do_action($id, 'edit', family_filter => 1);

                    # Проверяем статус
                    my $multistate = $app->$model->get($id, fields => ['multistate'])->{'multistate'};
                    my $got = $app->$model->check_multistate_flag($multistate, 'need_update');

                    is(
                        $got, '',
                        sprintf(
                            'id=%s, multistate=%d (%s) has no flag "need_update" after action "edit"',
                            $id, $multistate, $model
                        )
                      );
                }
            );
        }
    },
    do_not_die_on_fail => 1
);
