#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::More;

use Test::Partner2::Mock;
use Test::MockObject::Extends::Easy;
use Test::Partner::Utils qw(
  add_bookmaker_filter
  get_new_internal_rtb
  restore_table
  use_common_blocks_table
  );

no warnings 'redefine';

# global vars
$Test::Partner2::Mock::PAGE_ID_START = 123;
my $MOCKED_PAGE_ID = $Test::Partner2::Mock::PAGE_ID_START;

# subs

sub mock_db {
    my ($app) = @_;

    mock_yt_picategory_mapping($app);
    $app->partner_db->tns_dict_brand->add(
        {
            bid     => 1,
            name    => 'N/A',
            note    => 'Служебная запись для реклам без приложения',
            status  => 'A',
            file_id => 4929,
            hidden  => 0,
        },
    );

    $app->partner_db->tns_dict_brand->add(
        {
            bid     => 277,
            name    => 'NIKE',
            note    => '',
            status  => 'A',
            file_id => 1590,
            hidden  => 0,
        },
    );

    $app->partner_db->tns_dict_brand->add(
        {
            bid     => 163674,
            name    => 'CHAMELEON (KHBR)',
            note    => 'Продажа кожаной одежды',
            status  => 'A',
            file_id => 1590,
            hidden  => 0,
        },
    );

    $app->partner_db->tns_dict_article->add(
        {
            sid     => 0,
            grid    => 0,
            lev     => 0,
            name    => 'MAIN GROUP',
            note    => '',
            status  => 'A',
            file_id => 1590,
            hidden  => 0,
        },
    );

    $app->partner_db->picategories_dict->add(
        {
            category_id => 0,
            parent_id   => 0,
            level       => 0,
            name        => 'MAIN GROUP',
        },
    );

    my $table_dumps_dir = $app->get_option('ApplicationPath') . "t_old_test_data/statistics/2014_03_01/table_dumps";

    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'users');
    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp');
    restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp_type');
    $app->users->do_action(54519301, "edit", "email", "email\@email.com", "features", []);

    use_common_blocks_table($app);

    return FALSE;
}

sub mock_balance {
    my ($app) = @_;

    $app->{api_balance} = Test::MockObject::Extends::Easy->new($app->{api_balance});

    $app->api_balance->mock(
        'create_or_update_place',
        sub {
            my ($self, $method, $data) = @_;

            return [];
        }
    );
}

sub create_internal_context_campaign {
    my ($app) = @_;

    my $result = $app->internal_context_on_site_campaign->add(domain => 'example.com');

    return FALSE;
}

sub add_block_without_brand {
    my ($app) = @_;

    my $data = $app->internal_context_on_site_rtb->add(
        %{
            get_new_internal_rtb(
                {
                    campaign_id => $MOCKED_PAGE_ID,
                    dsps        => ['2317563'],
                }
            )
          }
    );

    return FALSE;
}

sub check_no_na_brand_in_suggest {
    my ($app) = @_;

    my $suggest = $app->tns_dict_brand->get_brand_suggest(block_id => 'R-I-123-1', substring => 'N');

    cmp_deeply(
        $suggest,
        [
            {
                bid   => 277,
                found => "N",
                name  => "NIKE",
                post  => "IKE",
                pre   => "",
            },
            {
                bid   => 163674,
                found => "N",
                name  => "CHAMELEON (KHBR)",
                post  => " (KHBR)",
                pre   => "CHAMELEO",
            },
        ],
        'Got expected brand suggest',
    );

}

sub cant_add_rtb_block_with_na_brand {
    my ($app) = @_;

    my $error;

    try {
        my $data = $app->internal_context_on_site_rtb->add(
            %{
                get_new_internal_rtb(
                    {
                        campaign_id => $MOCKED_PAGE_ID,
                        brands      => [
                            {
                                bid     => 1,
                                blocked => 1,
                            },
                            {
                                bid     => 277,
                                blocked => 0,
                                cpm     => 1,
                            },
                        ],
                        dsps => ['2317563'],
                    }
                )
              }
        );
    }
    catch {
        $error = shift;
    };

    is(
        $error->message(),
        to_json([{messages => [gettext("Entry with id: '%s' not found", 1)], name => ['brands']}], pretty => TRUE),
        'Got error about brand_id 1 in adding',
      );

    return FALSE;
}

sub can_add_rtb_block_with_correct_brand {
    my ($app) = @_;

    my $data = $app->internal_context_on_site_rtb->add(
        %{
            get_new_internal_rtb(
                {
                    campaign_id => $MOCKED_PAGE_ID,
                    brands      => [
                        {
                            bid     => "277",
                            blocked => 0,
                            cpm     => 1,
                        },
                    ],
                    dsps => ['2317563'],
                }
            )
          }
    );

    return FALSE;
}

sub cant_edit_block_with_na_brand {
    my ($app) = @_;

    my $error;

    try {
        my $data = $app->internal_context_on_site_rtb->do_action(
            'R-I-123-2',
            'edit',
            brands => [
                {
                    bid     => "1",
                    blocked => 1,
                },
                {
                    bid     => "277",
                    blocked => 0,
                    cpm     => 1,
                },
            ]
        );
    }
    catch {
        $error = shift;
    };

    cmp_deeply(
        $error->message(),
        to_json([{messages => [gettext("Entry with id: '%s' not found", 1)], name => ['brands']}], pretty => TRUE),
        'Got error about brand_id 1 in editing',
    );

    return FALSE;
}

sub can_edit_block_with_correct_brand {
    my ($app) = @_;

    my $error;

    try {
        my $data = $app->internal_context_on_site_rtb->do_action(
            'R-I-123-2',
            'edit',
            brands => [
                {
                    bid     => "163674",
                    blocked => 1
                },
                {
                    bid     => "277",
                    blocked => 0,
                    cpm     => 1,
                },
            ]
        );
    }
    catch {
        $error = shift;
    };

    is($error, undef, 'Got no error when editing with allowed brands',);

    return FALSE;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_db($app);
        mock_bk($app);
        mock_balance($app);
        mock_utils_partner2($app);
        mock_format_system($app);

        add_bookmaker_filter($app);

        create_internal_context_campaign($app);
        add_block_without_brand($app);    # creates 'R-I-123-1'

        check_no_na_brand_in_suggest($app);

        cant_add_rtb_block_with_na_brand($app);
        can_add_rtb_block_with_correct_brand($app);    # creates 'R-I-123-2'

        cant_edit_block_with_na_brand($app);
        can_edit_block_with_correct_brand($app);

    },
    fill_databases => 0,
    locale         => "en",
    init           => [qw(api_bk api_balance)],
);
__END__
