#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $data = {
            # page_id => {
            #     block_id => {
            #         bid => {
            #             blocked => 0,
            #             cpm     => 15,
            #         },
            #         ...
            #     },
            #     ...
            # },
            '154689' => {
                '1' => {'420' => {'blocked' => '1'}},
                '2' => {'420' => {'blocked' => '1'}}
            },
            '40' => {
                '1' => {
                    '52' => {
                        'blocked' => '0',
                        'cpm'     => '75'
                    }
                },
                '2' => {
                    '420' => {
                        'blocked' => '0',
                        'cpm'     => '120'
                    },
                    '52' => {'blocked' => '1'}
                }
            },
            '41443' => {
                '1'      => {'420' => {'blocked' => '1'}},
                '100000' => {'420' => {'blocked' => '1'}},
                '2'      => {
                    '420' => {
                        'blocked' => '0',
                        'cpm'     => '150'
                    }
                }
            },
            '43569' => {'1' => {'420' => {'blocked' => '1'}}}
        };

        get_all_and_cmp_with_data($app, $data, 'Initial data is ok');

        $app->brands->replace(
            {
                page_id  => 154689,
                block_id => 1,
            },
            [
                {
                    bid     => 420,
                    blocked => 0,
                    cpm     => 120,
                }
            ],
            'edit'
        );

        $data->{154689}->{1}->{420}->{blocked} = 0;
        $data->{154689}->{1}->{420}->{cpm}     = 120;

        get_all_and_cmp_with_data($app, $data, 'Change cpm is ok');

        $app->brands->replace(
            {
                page_id  => 154689,
                block_id => 1,
            },
            [
                {
                    bid     => 420,
                    blocked => 0,
                    cpm     => 120,
                },
                {
                    bid     => 52,
                    blocked => 0,
                    cpm     => 120,
                }
            ],
            'edit'
        );

        $data->{154689}->{1}->{52} = {
            blocked => 0,
            cpm     => 120,
        };

        get_all_and_cmp_with_data($app, $data, 'New brand successfully added');
    },
);

sub get_all_and_cmp_with_data {
    my ($app, $data, $msg) = @_;

    my $brands = {};
    foreach my $brand (@{$app->brands->get_all(fields => [qw(page_id block_id bid blocked cpm)])}) {
        $brands->{$brand->{page_id}}->{$brand->{block_id}}->{$brand->{bid}}->{blocked} = $brand->{blocked};
        $brands->{$brand->{page_id}}->{$brand->{block_id}}->{$brand->{bid}}->{cpm} = $brand->{cpm} + 0 if $brand->{cpm};
    }

    cmp_deeply($brands, $data, $msg);
}
