use Test::Partner2::Simple;

use Test::More tests => 17;
use Test::Deep qw(cmp_deeply ignore);
use Test::Most;

use Test::Partner2::Mock;
use Test::MockObject::Extends::Easy;
use Test::Partner::Utils qw(
  add_bookmaker_filter
  convert_design_to_object
  convert_design_to_templates
  get_new_internal_rtb
  mock_curdate
  restore_table
  use_common_blocks_table
  );

use PiConstants qw($BLOCKED_CPM_VALUE @YAN_MIRRORS_LIST);

use qbit;

no warnings 'redefine';

# global vars
$Test::Partner2::Mock::PAGE_ID_START = 12345;
my $MOCKED_PAGE_ID     = $Test::Partner2::Mock::PAGE_ID_START;
my $INTERNAL_CLIENT_ID = 944028;
my $mock_date          = '2016-07-15 18:09:34';

# subs
sub to_be_run_in_bk_mock {
    my ($data) = @_;

    return FALSE;
}

sub mock_balance {
    my ($app) = @_;

    $app->{api_balance} = Test::MockObject::Extends::Easy->new($app->{api_balance});

    $app->api_balance->mock(
        'create_or_update_place',
        sub {
            my ($self, %opts) = @_;

            return [];
        }
    );
}

sub create_internal_context_rtb_campaign {
    my ($app) = @_;

    note('creating campaign');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                0 => {
                    Description   => "example.com",
                    Domain        => "example.com",
                    IsYandexPage  => 1,
                    Name          => "example.com",
                    PartnerID     => $INTERNAL_CLIENT_ID,
                    Places        => ignore(),
                    PPCTotal      => 9,
                    State         => -1,
                    TargetType    => 3,
                    FastContext   => 1,
                    OnlyPicture   => 0,
                    MobileAppMode => 0,
                    Login         => 'adinside',
                    ProductID     => 'internal_context_on_site_campaign',
                    isPi2         => 1,
                    PageOptions   => {Enable => [], Disable => [qw(performance-tgo-disable)]},
                },
            },
            'Sending expedted data to BK (add)',
        );

        return FALSE;
    };

    my $result = $app->internal_context_on_site_campaign->add(domain => 'example.com');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                0 => {
                    BannerLang      => [],
                    CPA             => 100,
                    Description     => "example.com",
                    DisabledFlags   => 'bookmaker',
                    Domain          => "example.com",
                    IsYandexPage    => 1,
                    Mirrors         => join(',', @YAN_MIRRORS_LIST),
                    Name            => "example.com",
                    Options         => "ReloadTimeout=30",
                    PPCTotal        => 9,
                    PageID          => 12345,
                    PartnerID       => $INTERNAL_CLIENT_ID,
                    PicturesEnabled => 1,
                    PIEditTime      => $mock_date,
                    PageCaption     => 'example.com',
                    Places          => ignore(),
                    State           => 1,
                    TargetType      => 3,
                    excludeddomains => "",
                    ProductType     => 'context',
                    FastContext     => 1,
                    OnlyPicture     => 0,
                    MobileAppMode   => 0,
                    CreateDate      => $mock_date,
                    Login           => 'adinside',
                    ProductID       => 'internal_context_on_site_campaign',
                    isPi2           => 1,
                    PageOptions     => {
                        'Enable'  => ['adblock', 'redir-to-page-handler'],
                        'Disable' => [
                            qw(
                              performance-tgo-disable
                              unmoderated-rtb-auction
                              )
                        ]
                    },
                    Lang         => 'ru',
                    BannerLang   => ['by', 'en', 'kz', 'ru', 'uk'],
                    OrderTags    => [],
                    TargetTags   => [],
                    UpdateTimePI => $mock_date,
                },
            },
            'Sending expedted data to BK (register_in_balance)',
        );

        return FALSE;
    };

    $app->internal_context_on_site_campaign->do_action(12345, 'register_in_balance',);
    $app->internal_context_on_site_campaign->update_in_bk({id => 12345});

    return FALSE;
}

sub create_rtb_block {
    my ($app) = @_;

    note('creating block');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        # При выполнении app->internal_context_on_site_rtb->add отправка в БК
        # происходит 2 раза: сначала в on_action_save_dsps(), а потом в
        # on_action_start(). При первой отправке поля RtbBlocks нет, а при
        # второй есть. Чтобы упростить написание теста убираем RtbBlocks из
        # проверки
        delete $data->{0}->{RtbBlocks};
        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                0 => {
                    BannerLang      => [],
                    CPA             => 100,
                    Description     => "example.com",
                    DisabledFlags   => 'bookmaker',
                    Domain          => "example.com",
                    excludeddomains => "",
                    IsYandexPage    => 1,
                    Mirrors         => join(',', @YAN_MIRRORS_LIST),
                    Name            => "example.com",
                    Options         => "ReloadTimeout=30",
                    PageID          => 12345,
                    PartnerID       => $INTERNAL_CLIENT_ID,
                    PicturesEnabled => 1,
                    PIEditTime      => $mock_date,
                    PageCaption     => 'example.com',
                    Places          => ignore(),
                    PPCTotal        => 9,
                    State           => 1,
                    TargetType      => 3,
                    ProductType     => 'context',
                    FastContext     => 1,
                    OnlyPicture     => 0,
                    MobileAppMode   => 0,
                    CreateDate      => $mock_date,
                    Login           => 'adinside',
                    ProductID       => 'internal_context_on_site_campaign',
                    isPi2           => 1,
                    PageOptions     => {
                        'Enable'  => ['adblock', 'redir-to-page-handler'],
                        'Disable' => [qw(performance-tgo-disable unmoderated-rtb-auction)]
                    },
                    Lang         => 'ru',
                    BannerLang   => ['by', 'en', 'kz', 'ru', 'uk'],
                    OrderTags    => [],
                    TargetTags   => [],
                    UpdateTimePI => $mock_date,
                },
            },
            'Sending expedted data to BK',
        );

        return FALSE;
    };

    my $result = $app->internal_context_on_site_rtb->add(
        %{
            get_new_internal_rtb(
                {
                    campaign_id => 12345,
                    strategy    => 3,
                    dsps        => ['2317563'],
                }
            )
          }
    );

    $app->internal_context_on_site_rtb->do_action(
        $result,
        'edit',
        picategories => [{id  => "1", cpm     => 30}],
        brands       => [{bid => 52,  blocked => 1}]
    );

    $app->internal_context_on_site_campaign->update_in_bk({id => 12345});

    return FALSE;
}

sub check_getting_rtb_block {
    my ($app) = @_;

    my $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    my %bk_data;
    for my $block (@$data) {
        $bk_data{$block->{campaign_id}} = {$app->internal_context_on_site_rtb->get_bk_data($block->{campaign_id})};
    }

    cmp_deeply(
        \%bk_data,
        {
            '12345' => {
                'rtb_blocks' => {
                    '1' => {
                        'AdFoxBlock'    => 0,
                        'PICategoryIAB' => {
                            '1' => {
                                'MediaCreativeReach' => 30000,
                                'MediaImageReach'    => 30000
                            },
                            '2' => {
                                'MediaCreativeReach' => 30000,
                                'MediaImageReach'    => 30000

                            },
                            '3' => {
                                'MediaCreativeReach' => 30000,
                                'MediaImageReach'    => 30000
                            }
                        },
                        'AdType' => {
                            'text' => {
                                'currency' => 'RUB',
                                'value'    => 150000
                            },
                        },
                        'AdTypeSet' => {
                            'media'             => 0,
                            'media-performance' => 0,
                            'text'              => 1,
                            'video'             => 0,
                            'video-motion'      => 0,
                            'video-performance' => 0
                        },
                        'AlternativeCode' => '',
                        'PICategoryIAB'   => {'1' => {'MediaCreativeReach' => 30000, 'MediaImageReach' => 30000}},
                        'BlindLevel'      => 2,
                        'BlockModel'      => 'internal_context_on_site_rtb',
                        'BlockCaption'    => 'RTB block (campaign: 12345)',
                        'Brand'           => {'52' => {'currency' => 'RUB', 'value' => $BLOCKED_CPM_VALUE}},
                        'CustomBlockData' => {'only-portal-trusted-banners' => 0,},
                        'DSPInfo'         => [
                            {
                                'CPM'   => 0,
                                'DSPID' => 2317563,
                            }
                        ],
                        'DSPSettings' => {
                            'DSP'         => [2317563],
                            'DSPBindMode' => 'force',
                            'Unmoderated' => []
                        },
                        'MinCPM'         => 0,
                        'DSPType'        => 1,
                        'DirectLimit'    => 1,
                        'Geo'            => {},
                        'Height'         => 600,
                        'MultiState'     => 2,
                        'OptimizeType'   => 0,
                        'PageImpOptions' => {
                            'Enable'  => [],
                            'Disable' => [
                                'filter-sizes', 'fullscreen', 'ignore-0x0-adaptive-sizes', 'rewarded',
                                'rtbshadow',    'turbo',      'turbo-desktop'
                            ]
                        },
                        'RtbDesign' => {
                            '2' => {
                                'design' => {
                                    'blockId'         => 'R-I-12345-1',
                                    'filterSizes'     => JSON::XS::false,
                                    'horizontalAlign' => JSON::XS::false,
                                },
                                'name' => "media design",
                                'type' => 'media'
                            },
                            '1' => {
                                'design' => {
                                    'blockId' => 'R-I-12345-1',
                                    'limit'   => 1,
                                    'name'    => '240x400'
                                },
                                'name' => 'template',
                                'type' => 'tga',
                            }
                        },
                        'Sizes' => [
                            {
                                'Height' => 400,
                                'Width'  => 240
                            },
                            {
                                'Height' => 600,
                                'Width'  => 300
                            },
                            {
                                'Height' => 0,
                                'Width'  => 0,
                            },
                        ],
                        'Width'      => 300,
                        'OrderTags'  => [],
                        'TargetTags' => [],
                    }
                }
            },
        },
        'Got expected bk_data for RTB block'
    );

    cmp_deeply(
        $data,
        [
            {
                'is_custom_bk_data' => 0,
                'id'                => 1,
                'campaign_id'       => 12345
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub set_custom_bk_data_for_block {
    my ($app) = @_;

    note('setting custom bk data for block');

    my $result = $app->internal_context_on_site_rtb->do_action(
        'R-I-12345-1',
        'edit',
        is_custom_bk_data => 1,
        bk_data           => to_json({RtbDesign => convert_design_to_object('"test":1'), a => 1, b => \0}),
    );

    my $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 1
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : false
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub cant_edit_rtb_block_with_flag_is_custom_bk_data {
    my ($app) = @_;

    note('Trying to edit block with is_custom_bk_data = 1');

    my $err;
    try {
        my $result = $app->internal_context_on_site_rtb->do_action('R-I-12345-1', 'edit', site_bg_color => 'FF00FF',);
    }
    catch {
        $err = $_[0];
    };

    ok($err, "Can't edit block with is_custom_bk_data = 1");

    return FALSE;
}

sub check_that_custom_bk_data_is_send {
    my ($app) = @_;

    note('Testing that correct custom bk data is send');

    my $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 1
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : false
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                0 => {
                    BannerLang      => [],
                    CPA             => 100,
                    Description     => "example.com",
                    DisabledFlags   => 'bookmaker',
                    Domain          => "example.com",
                    excludeddomains => "",
                    IsYandexPage    => 1,
                    Mirrors         => join(',', @YAN_MIRRORS_LIST),
                    Name            => "example.com",
                    Options         => "ReloadTimeout=30",
                    PageID          => 12345,
                    PartnerID       => 944028,
                    PicturesEnabled => 1,
                    PIEditTime      => $mock_date,
                    PageCaption     => 'example.com',
                    Places          => ignore(),
                    PPCTotal        => 9,
                    State           => 1,
                    TargetType      => 3,
                    ProductType     => 'context',
                    RtbBlocks       => {
                        1 => {
                            a                => 1,
                            b                => 2,
                            AllowedImageType => ['small', 'regular'],
                            RtbDesign        => convert_design_to_object('"test":1'),
                        }
                    },
                    FastContext   => 1,
                    OnlyPicture   => 0,
                    MobileAppMode => 0,
                    CreateDate    => $mock_date,
                    Login         => 'adinside',
                    ProductID     => 'internal_context_on_site_campaign',
                    isPi2         => 1,
                    PageOptions   => {
                        'Enable'  => ['adblock', 'redir-to-page-handler'],
                        'Disable' => [qw(performance-tgo-disable unmoderated-rtb-auction)]
                    },
                    Lang         => 'ru',
                    BannerLang   => ['by', 'en', 'kz', 'ru', 'uk'],
                    OrderTags    => [],
                    TargetTags   => [],
                    UpdateTimePI => $mock_date,
                },
            },
            'Sending expedted data to BK',
        );

        return FALSE;
    };

    my $result =
      $app->internal_context_on_site_rtb->do_action('R-I-12345-1', 'edit',
        bk_data => to_json({RtbDesign => convert_design_to_object('"test":1'), a => 1, b => 2}),);
    $app->internal_context_on_site_campaign->update_in_bk({id => 12345});

    $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 1
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : 2
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub check_bk_data_must_be_json {
    my ($app) = @_;

    note("Cheking that one can't use sting instead of json for bk_data");

    my $err;
    try {
        my $result = $app->internal_context_on_site_rtb->do_action('R-I-12345-1', 'edit', bk_data => 'asdf',);
    }
    catch {
        $err = $_[0];
    };

    ok($err, "Can't set incorrect bk_data for block");

    my $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 1
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : 2
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

sub check_switch_off_is_custom_bk_data {
    my ($app) = @_;

    note('switching is_custom_bk_data off');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                '0' => {
                    'PageID'          => 12345,
                    'Options'         => 'ReloadTimeout=30',
                    'PicturesEnabled' => 1,
                    'PIEditTime'      => $mock_date,
                    'State'           => 1,
                    'BannerLang'      => [],
                    'PartnerID'       => 944028,
                    'CPA'             => 100,
                    'Places'          => {542 => isa('SOAP::Data')},
                    'RtbBlocks'       => {
                        '1' => {
                            'AdFoxBlock'    => 0,
                            'PICategoryIAB' => {
                                '1' => {
                                    'MediaCreativeReach' => 30000,
                                    'MediaImageReach'    => 30000
                                },
                                '2' => {
                                    'MediaCreativeReach' => 30000,
                                    'MediaImageReach'    => 30000

                                },
                                '3' => {
                                    'MediaCreativeReach' => 30000,
                                    'MediaImageReach'    => 30000
                                }
                            },
                            'BlockModel'     => 'internal_context_on_site_rtb',
                            'PageImpOptions' => {
                                'Enable'  => [],
                                'Disable' => [
                                    'filter-sizes',              'fullscreen',
                                    'ignore-0x0-adaptive-sizes', 'rewarded',
                                    'rtbshadow',                 'turbo',
                                    'turbo-desktop'
                                ]
                            },
                            'RtbDesign' => {
                                '2' => {
                                    'design' => {
                                        'blockId'         => 'R-I-12345-1',
                                        'filterSizes'     => JSON::XS::false,
                                        'horizontalAlign' => JSON::XS::false,
                                    },
                                    'name' => "media design",
                                    'type' => 'media'
                                },
                                '1' => {
                                    'design' => {
                                        'blockId' => 'R-I-12345-1',
                                        'limit'   => 1,
                                        'name'    => '240x400'
                                    },
                                    'name' => 'template',
                                    'type' => 'tga',
                                }
                            },
                            'AdTypeSet' => {
                                'media'             => 0,
                                'text'              => 1,
                                'media-performance' => 0,
                                'video'             => 0,
                                'video-motion'      => 0,
                                'video-performance' => 0,
                            },
                            'AllowedImageType' => ['small', 'regular', 'wide'],
                            'OptimizeType'     => 0,
                            'Height'           => '600',
                            'BlockCaption'     => 'RTB block (campaign: 12345)',
                            'MultiState'       => 18,
                            'Brand' => {'52' => {'currency' => 'RUB', 'value' => $BLOCKED_CPM_VALUE}},
                            'Sizes' => [
                                {
                                    'Height' => '400',
                                    'Width'  => '240'
                                },
                                {
                                    'Height' => '600',
                                    'Width'  => '300'
                                },
                                {
                                    'Height' => '0',
                                    'Width'  => '0'
                                }
                            ],
                            'Width'           => '300',
                            'BlindLevel'      => 2,
                            'DSPType'         => 1,
                            'AlternativeCode' => '',
                            'PICategoryIAB'   => {'1' => {'MediaCreativeReach' => 30000, 'MediaImageReach' => 30000}},
                            'AdType'          => {
                                'text' => {
                                    'currency' => 'RUB',
                                    'value'    => 150000
                                },
                            },
                            'DSPInfo'     => [{"CPM" => 0, "DSPID" => 2317563,}],
                            'DSPSettings' => {
                                'DSP'         => [2317563],
                                'DSPBindMode' => 'force',
                                'Unmoderated' => []
                            },
                            'MinCPM'          => 0,
                            'DirectLimit'     => 1,
                            'Geo'             => isa('SOAP::Data'),
                            'OrderTags'       => [],
                            'TargetTags'      => [],
                            'CustomBlockData' => {'only-portal-trusted-banners' => 0,},
                        }
                    },
                    'IsYandexPage'    => 1,
                    'excludeddomains' => '',
                    'ProductType'     => 'context',
                    'Domain'          => 'example.com',
                    'Mirrors'         => join(',', @YAN_MIRRORS_LIST),
                    'TargetType'      => 3,
                    'PPCTotal'        => 9,
                    'DisabledFlags'   => 'bookmaker',
                    'Description'     => 'example.com',
                    'Name'            => 'example.com',
                    'PageCaption'     => 'example.com',
                    'FastContext'     => 1,
                    'OnlyPicture'     => 0,
                    'MobileAppMode'   => 0,
                    'CreateDate'      => '',
                    'CreateDate'      => $mock_date,
                    'Login'           => 'adinside',
                    'ProductID'       => 'internal_context_on_site_campaign',
                    'isPi2'           => 1,
                    'PageOptions'     => {
                        'Enable'  => ['adblock', 'redir-to-page-handler'],
                        'Disable' => [qw(performance-tgo-disable unmoderated-rtb-auction)],
                    },
                    'Lang'         => 'ru',
                    'BannerLang'   => ['by', 'en', 'kz', 'ru', 'uk'],
                    'OrderTags'    => [],
                    'TargetTags'   => [],
                    'UpdateTimePI' => $mock_date,
                }
            },
            'Sending expedted data to BK',
        );

        return FALSE;
    };

    my $result = $app->internal_context_on_site_rtb->do_action('R-I-12345-1', 'edit', is_custom_bk_data => 0,);
    $app->internal_context_on_site_campaign->update_in_bk({id => 12345});

    return FALSE;
}

sub check_both {
    my ($app) = @_;

    note('Testing that edit works when specifying both bk_data & is_custom_bk_data');

    my $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 1
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : 2
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        delete $data->{'0'}->{'Slots'};

        cmp_deeply(
            $data,
            {
                0 => {
                    BannerLang      => [],
                    CPA             => 100,
                    Description     => "example.com",
                    DisabledFlags   => 'bookmaker',
                    Domain          => "example.com",
                    excludeddomains => "",
                    IsYandexPage    => 1,
                    Mirrors         => join(',', @YAN_MIRRORS_LIST),
                    Name            => "example.com",
                    Options         => "ReloadTimeout=30",
                    PageID          => 12345,
                    PartnerID       => 944028,
                    PicturesEnabled => 1,
                    PIEditTime      => $mock_date,
                    PageCaption     => 'example.com',
                    Places          => ignore(),
                    PPCTotal        => 9,
                    State           => 1,
                    TargetType      => 3,
                    ProductType     => 'context',
                    RtbBlocks       => {
                        1 => {
                            a                => 1,
                            b                => 2,
                            AllowedImageType => ['small', 'regular'],
                            RtbDesign        => convert_design_to_object('"test":2'),
                        }
                    },
                    FastContext   => 1,
                    OnlyPicture   => 0,
                    MobileAppMode => 0,
                    Login         => 'adinside',
                    CreateDate    => $mock_date,
                    ProductID     => 'internal_context_on_site_campaign',
                    isPi2         => 1,
                    PageOptions   => {
                        'Enable'  => ['adblock', 'redir-to-page-handler'],
                        'Disable' => [qw(performance-tgo-disable unmoderated-rtb-auction)],
                    },
                    Lang         => 'ru',
                    BannerLang   => ['by', 'en', 'kz', 'ru', 'uk'],
                    OrderTags    => [],
                    TargetTags   => [],
                    UpdateTimePI => $mock_date,
                },
            },
            'Sending expedted data to BK',
        );

        return FALSE;
    };

    my $result = $app->internal_context_on_site_rtb->do_action(
        'R-I-12345-1',
        'edit',
        bk_data           => to_json({RtbDesign => convert_design_to_object('"test":2'), a => 1, b => 2}),
        is_custom_bk_data => 1,
    );
    $app->internal_context_on_site_campaign->update_in_bk({id => 12345});

    $data = $app->internal_context_on_site_rtb->get_all(
        fields => [
            qw(
              bk_data
              campaign_id
              id
              is_custom_bk_data
              )
        ],
    );

    cmp_deeply(
        $data,
        [
            {
                campaign_id       => 12345,
                id                => 1,
                is_custom_bk_data => 1,
                bk_data           => '{
   "RtbDesign" : {
      "0" : {
         "design" : {
            "test" : 2
         },
         "name" : ""
      }
   },
   "a" : 1,
   "b" : 2
}
',
            },
        ],
        'Got expected data for RTB block',
    );

    return FALSE;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_utils_partner2($app);
        mock_yt_picategory_mapping($app);

        $app->partner_db->tns_dict_article->add_multi(
            [
                {
                    'sid'  => '0',
                    'lev'  => '0',
                    'name' => 'MAIN GROUP'
                },
                {
                    'sid'  => '40',
                    'lev'  => '2',
                    'name' => 'COMMUNICATIONS MEANS & EQUIPMENT'
                }
            ]
        );

        $app->partner_db->tns_dict_brand->add(
            {
                'bid'     => 52,
                'name'    => 'SAMSUNG',
                'note'    => '',
                'status'  => 'A',
                'file_id' => 1590,
                'hidden'  => 0,
            }
        );

        my $table_dumps_dir = $app->get_option('ApplicationPath') . "t_old_test_data/statistics/2014_03_01/table_dumps";

        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'users');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'picategories_dict');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp_type');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'bk_language');

        mock_bk($app);
        mock_balance($app);
        mock_format_system($app);
        add_bookmaker_filter($app);
        mock_curdate($mock_date);

        $app->users->do_action(54519301, "edit", "email", "email\@email.com", "features", []);

        use_common_blocks_table($app);

        create_internal_context_rtb_campaign($app);
        create_rtb_block($app);
        check_getting_rtb_block($app);
        set_custom_bk_data_for_block($app);
        cant_edit_rtb_block_with_flag_is_custom_bk_data($app);
        check_that_custom_bk_data_is_send($app);
        check_bk_data_must_be_json($app);
        check_both($app);
        check_switch_off_is_custom_bk_data($app);

    },
    fill_databases => 0,
    locale         => "en",
    init           => [qw(api_bk api_balance)]
);
