use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply ignore);
use Test::Partner2::Mock;
use Test::Partner::Utils qw(
  add_bookmaker_filter
  get_new_internal_rtb
  restore_table
  use_common_blocks_table
  );
use Test::Partner2::Mock qw(mock_format_system);

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        mock_utils_partner2($app);

        mock_format_system($app);
        mock_yt_picategory_mapping($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . "t_old_test_data/statistics/2014_03_01/table_dumps";
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'users');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'dsp_type');
        restore_table($app->partner_db->get_dbh, $table_dumps_dir, 'bk_language');

        $app->users->do_action(54519301, "edit", "email", "email\@email.com", "features", []);
        my $PAGE_ID = 999;

        $app->api_bk;
        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{api_bk});
        $app->api_bk->mock('create_or_update_campaign', sub {$PAGE_ID});

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
        $app->api_balance->set_always('create_or_update_place', TRUE);

        $app->partner_db->tns_dict_article->add(
            {
                sid     => 0,
                grid    => 0,
                lev     => 0,
                name    => 'MAIN GROUP',
                note    => '',
                status  => 'A',
                file_id => 1590,
                hidden  => 0,
            },
        );

        $app->partner_db->picategories_dict->add(
            {
                category_id => 0,
                parent_id   => 0,
                level       => 0,
                name        => 'MAIN GROUP',
            },
        );

        add_bookmaker_filter($app);

        use_common_blocks_table($app);

        my $campaign_id = $app->internal_context_on_site_campaign->add(domain => 'partner2.yandex.ru');

        my @mirrors =
          (@{$app->internal_context_on_site_campaign->mirrors->get_all()}, qw(mirror.com port.mirror.com:1234));
        $app->internal_context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => \@mirrors);

        {
            my $result = $app->internal_context_on_site_campaign->get($campaign_id, fields => [qw/domain mirrors/]);

            is_deeply(
                $result,
                {
                    'domain'  => 'partner2.yandex.ru',
                    'mirrors' => ['mirror.com', 'port.mirror.com:1234']
                },
                'Check mirrors (with ports)'
            );
        }

        my @rtb_blocks = (
            get_new_internal_rtb({campaign_id => $campaign_id, dsps => ['2563049']}),
            get_new_internal_rtb({campaign_id => $campaign_id, dsps => ['2563049']}),
        );

        $app->internal_context_on_site_rtb->add(%$_) foreach @rtb_blocks;

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => [
                    "id" => "NOT IN" => ["R-I-$campaign_id-1",],

                ],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => [
                    "id" => "<>" => ["R-I-$campaign_id-1",],

                ],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => [
                    "id" => "=" => "R-I-$campaign_id-2",

                ],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => [
                    "id" => "<>" => "R-I-$campaign_id-1",

                ],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => ["id" => "NOT IN" => ["R-I-$campaign_id-1", 1,],],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        {
            my $result = $app->internal_context_on_site_rtb->get_all(
                fields => [qw(public_id),],
                filter => ["id" => "<>" => 1,],
            );

            is_deeply($result, [{public_id => "R-I-$campaign_id-2"}]);
        }

        #Duplicate RTB

        my $dup_rtb = $app->internal_context_on_site_rtb->duplicate(public_id => "R-I-$campaign_id-1");

        cmp_deeply(
            $app->internal_context_on_site_rtb->get(
                $dup_rtb, fields => [keys(%{$app->internal_context_on_site_rtb->get_add_fields}), 'dsps']
            ),
            $app->internal_context_on_site_rtb->get(
                "R-I-$campaign_id-3", fields => [keys(%{$app->internal_context_on_site_rtb->get_add_fields}), 'dsps']
            ),
            'Duplicate RTB'
        );
    },
    fill_databases => 0,
    locale         => "en",
);
