#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Partner2::Mock;

use Test::Partner::Utils qw(get_new_internal_mobile_app get_test_data_and_update_if_needed);

use qbit;

my $manager       = {id => 7169516, login => 'hajtina'};
my $administartor = {id => 1019,    login => 'mocked-internal-mobile-app-administrator'};
my $viewer        = {id => 1020,    login => 'mocked-internal-mobile-app-viewer'};

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);
        mock_utils_partner2($app);

        note("I am administrator!");
        $app->set_cur_user({id => $administartor->{'id'}});

        my $page_id = $app->internal_mobile_app->add(get_new_internal_mobile_app({store_id => 'com.test'}));

        my $got = $app->internal_mobile_app->get($page_id, fields => ['*']);
        my $expected = get_test_data_and_update_if_needed('get_administrator.json', $got);

        cmp_deeply($got, $expected, 'internal_mobile_app->get administrator');

        $app->partner_db->managers->add({manager_id => $manager->{'id'}, page_id => $page_id});

        cmp_deeply(
            $app->internal_mobile_app->get($page_id, fields => [qw(managers manager_ids)]),
            {'manager_ids' => [$manager->{'id'}], 'managers' => [$manager->{'login'}]},
            'check managers'
        );

        note("I am manager!");
        $app->set_cur_user({id => $manager->{'id'}});

        $got =
          $app->internal_mobile_app->get($page_id, fields => [keys(%{$app->internal_mobile_app->get_model_fields()})]);
        $expected = get_test_data_and_update_if_needed('get_manager.json', $got);

        cmp_deeply($got, $expected, 'internal_mobile_app->get manager');

        note("I am viewer!");
        $app->set_cur_user({id => $viewer->{'id'}});

        $got =
          $app->internal_mobile_app->get($page_id, fields => [keys(%{$app->internal_mobile_app->get_model_fields()})]);
        $expected = get_test_data_and_update_if_needed('get_viewer.json', $got);
        cmp_deeply($got, $expected, 'internal_mobile_app->get viewer');
    },
    user => $manager->{'login'},
);

sub mock_app {
    my ($app) = @_;

    mock_curdate('2016-05-27 17:59:10');
    mock_bk($app);
    mock_balance($app);
    mock_agreement_checker($app);
}
