#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;
use Test::Partner2::Simple;

my %empty_fields = (
    map {$_ => undef}
      qw (bg_color  border_color    border_radius    border_type          font_family
      font_size     header_bg_color horizontal_align hover_color          links_underline
      media_active  media_blocked   media_cpm        mincpm
      site_bg_color sitelinks_color text_active      text_blocked         text_color
      text_cpm      title_color     title_font_size  url_background_color url_color)
);

run_tests(
    sub {
        my ($app) = @_;

        $app->internal_mobile_app->do_action(132439, 'edit');

        #Добавление нативного блока с пустыми полями
        my $id = $app->internal_mobile_app_rtb->add(
            'caption'        => 'Мобильный RTB-блок',
            'comment'        => 'comment',
            'dsps'           => ['1'],
            'geo'            => '[]',
            'strategy'       => '1',
            'block_type'     => 'native',
            'application_id' => '132439',
            %empty_fields
        );

        #Получение полей добавленного блока
        my $rtb = $app->internal_mobile_app_rtb->get_all(
            fields => [
                qw (bg_color      border_color    border_radius   border_type
                  font_family     font_size       header_bg_color horizontal_align
                  hover_color     links_underline media_active    media_blocked
                  media_cpm       mincpm           site_bg_color
                  sitelinks_color text_active     text_blocked    text_color
                  text_cpm        title_color     title_font_size url_background_color
                  url_color)
            ],
            filter => ['public_id', '=', $id]
        );

        cmp_deeply($rtb->[0], \%empty_fields, "Added empty fields.");

        $app->internal_mobile_app_rtb->do_action('R-IM-132439-3', 'edit', 'comment' => 'test');
    }
);
