#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils;

use Test::More;
use Test::Deep qw(cmp_deeply re);

my $page_id = 132439;

my $fixture = {
    "banner" => {
        "block_type" => "banner",
        "methods"    => {
            "get_types_direct_blocks" => {},
            "get_types_media_blocks"  => {},
            "get_types_dsp_blocks"    => {},
        }
    },
    "native" => {
        "block_type" => "native",
        "methods"    => {
            "get_types_direct_blocks" => {},
            "get_types_media_blocks"  => {},
            "get_types_dsp_blocks"    => {},
        }
    }
};

run_tests(
    sub {
        my ($app) = @_;

        my $path_to_data = lib::abs::path('direct_blocks/data.json');

        my $json_data = from_json(readfile($path_to_data));

        my $got_data = {};
        foreach my $case_name (keys %$fixture) {

            my ($block_type, $methods) = @{$fixture->{$case_name}}{qw( block_type  methods )};

            subtest $case_name => sub {
                note 'Start  ' . $case_name;

                $got_data->{$case_name} = {
                    "block_type" => $block_type,
                    "methods"    => {}
                };

                foreach my $method (keys %$methods) {
                    my $expect  = $json_data->{$case_name}->{methods}->{$method};
                    my $new_got = compare_formats(
                        $app->internal_mobile_app_rtb->$method(
                            {
                                'application_id' => $page_id,
                                'block_type'     => $block_type,
                            }
                        ),
                        $expect,
                        sprintf '%s (%s, %s)',
                        $method,
                        $case_name,
                        $block_type
                    );

                    $got_data->{$case_name}->{methods}->{$method} = $new_got;
                }
              }
        }

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            writefile($path_to_data, to_json($got_data, pretty => TRUE));
        }

    },
    do_not_die_on_fail => TRUE,
);
