#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More tests => 6;
use Test::Differences qw(eq_or_diff);

use qbit;
use Test::Partner2::Simple;

my @common = qw(application_id articles bg_color block_type border_color border_radius border_type brands
  caption comment custom_bk_options dsps font_family font_size geo header_bg_color horizontal_align hover_color
  links_underline mincpm mobile_app_mode order_tags page_id picategories site_bg_color
  sitelinks_color strategy target_tags text_color title_color title_font_size url_background_color url_color
  dsp_mode
  );

my %block_type_fields = (
    banner => [
        @common,
        qw(adaptive_height adaptive_width callouts direct_block dsp_blocks favicon limit media_block no_sitelinks
          media_active media_blocked media_cpm text_active text_blocked text_cpm show_video)
    ],
    interstitial => [
        @common,
        qw(callouts close_button_delay media_active media_blocked media_cpm text_active text_blocked text_cpm show_video)
    ],
    native => [
        @common,
        qw(dsp_blocks limit media_active media_blocked media_cpm text_active text_blocked text_cpm show_video show_slider)
    ],
    adaptive_banner => [
        @common,
        qw(adaptive_height adaptive_width callouts direct_block dsp_blocks favicon limit media_block no_sitelinks)
    ],
);

run_tests(
    sub {
        my ($app) = @_;

        foreach (keys %block_type_fields) {
            eq_or_diff(
                [sort keys %{$app->internal_mobile_app_rtb->get_add_fields($_)}],
                [sort @{$block_type_fields{$_}}],
                " - add fields for $_ block type ok"
            );
        }
    },
    user => 'mocked-internal-administrator',
);
