#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Deep;

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_balance mock_bk mock_utils_partner2);

use Test::Partner::Utils qw(get_new_internal_mobile_app get_new_internal_mobile_rtb get_bk_data);

use PiConstants qw(@VIDEO_INTERSTITIAL_DSPS $DSP_BANNER_FORMAT_ID);

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);
        mock_utils_partner2($app);

        my $multistate = $app->dsp->get_multistates_by_filter(
            'created_in_bk and (created_in_pi or not_need_create_in_pi) and linked_in_balance and not deleted')->[0];
        $app->partner_db->dsp->add_multi([map {{id => $_, multistate => $multistate}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_type->add_multi([map {{dsp_id => $_, type_id => 2}} @VIDEO_INTERSTITIAL_DSPS]);
        $app->partner_db->dsp_format->add_multi(
            [map {{dsp_id => $_, format_id => $DSP_BANNER_FORMAT_ID}} @VIDEO_INTERSTITIAL_DSPS]);

        change_cur_user($app, 'mocked-internal-administrator');

        my $mobile_app_id = $app->internal_mobile_app->add(get_new_internal_mobile_app({store_id => 'com.test'}));

        my $public_id = $app->internal_mobile_app_rtb->add(
            get_new_internal_mobile_rtb({application_id => $mobile_app_id, block_type => 'interstitial'}));

        my $bk_data = get_bk_data($app->internal_mobile_app, {id => $mobile_app_id});

        cmp_deeply(
            $bk_data->{'rtb_blocks'}{'1'}{'AdTypeSet'},
            {
                'media'             => 1,
                'media-performance' => 0,
                'text'              => 1,
                'video'             => 0,
                'video-performance' => 0,
                'video-motion'      => 0,
            },
            'AdTypeSet: show_video = 0'
        );

        cmp_deeply([map {$_->{'DSPID'}} @{$bk_data->{'rtb_blocks'}{'1'}{'DSPInfo'}}], [1], 'DSPInfo: show_video = 0');

        $app->internal_mobile_app_rtb->do_action($public_id, 'edit', show_video => 1);

        $bk_data = get_bk_data($app->internal_mobile_app, {id => $mobile_app_id});

        cmp_deeply(
            $bk_data->{'rtb_blocks'}{'1'}{'AdTypeSet'},
            {
                'media'             => 1,
                'media-performance' => 0,
                'text'              => 1,
                'video'             => 1,
                'video-performance' => 1,
                'video-motion'      => 1,
            },
            'AdTypeSet: show_video = 1'
        );

        cmp_deeply(
            [map {$_->{'DSPID'}} @{$bk_data->{'rtb_blocks'}{'1'}{'DSPInfo'}}],
            [1, @VIDEO_INTERSTITIAL_DSPS],
            'DSPInfo: show_video = 1'
        );

        $app->internal_mobile_app_rtb->do_action($public_id, 'edit', show_video => 0);

        $bk_data = get_bk_data($app->internal_mobile_app, {id => $mobile_app_id});

        cmp_deeply(
            $bk_data->{'rtb_blocks'}{'1'}{'AdTypeSet'},
            {
                'media'             => 1,
                'media-performance' => 0,
                'text'              => 1,
                'video'             => 0,
                'video-performance' => 0,
                'video-motion'      => 0,
            },
            'AdTypeSet: set show_video = 0'
        );

        cmp_deeply([map {$_->{'DSPID'}} @{$bk_data->{'rtb_blocks'}{'1'}{'DSPInfo'}}],
            [1], 'DSPInfo: set show_video = 0');
    },
);

sub mock_app {
    my ($app) = @_;

    mock_balance($app);

    mock_bk($app);
}
